/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.language.UnicodeBasedLangIdentifier;

public class UnicodeBasedLangIdentifierTest {
    private final UnicodeBasedLangIdentifier ident = new UnicodeBasedLangIdentifier(100);

    @Test
    public void testGetAdditionalLangCodes() {
        String arabic = "[ar, fa]";
        String cyrillic = "[ru, uk, be]";
        String cjk = "[zh, ja]";
        String devanagari = "[hi, mr]";
        Assert.assertThat((Object)this.codes(""), (Matcher)CoreMatchers.is((Object)"[]"));
        Assert.assertThat((Object)this.codes(" "), (Matcher)CoreMatchers.is((Object)"[]"));
        Assert.assertThat((Object)this.codes("hallo"), (Matcher)CoreMatchers.is((Object)"[]"));
        Assert.assertThat((Object)this.codes("hallo this is a text"), (Matcher)CoreMatchers.is((Object)"[]"));
        Assert.assertThat((Object)this.codes("hallo this is a text \u0441\u0442\u0438\u043b\u044c"), (Matcher)CoreMatchers.is((Object)"[]"));
        Assert.assertThat((Object)this.codes("\u0413\u0440\u0430\u043c\u043c\u0430\u0442\u0438\u043a\u0430, \u0441\u0442\u0438\u043b\u044c \u0438 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0438\u044f LanguageTool \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442 \u0432\u0430\u0448\u0435 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c 20 \u044f\u0437\u044b\u043a\u0430\u0445"), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442 \u0432\u0430\u0448\u0435 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c 20 \u044f\u0437\u044b\u043a\u0430\u0445"), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u0430 \u043f\u0435\u0440\u0435\u0432\u0456\u0440\u043a\u0438 \u0433\u0440\u0430\u043c\u0430\u0442\u0438\u043a\u0438, \u0441\u0442\u0438\u043b\u044e \u0442\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u0457. LanguageTool \u043f\u0435\u0440\u0435\u0432\u0456\u0440\u044f\u0454 \u0432\u0430\u0448\u0456 \u0442\u0435\u043a\u0441\u0442\u0438 \u0431\u0456\u043b\u044c\u0448 \u043d\u0456\u0436 20-\u043c\u0430 \u043c\u043e\u0432\u0430\u043c\u0438"), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u0421\u0443\u0447\u0430\u0441\u043d\u0430\u044f \u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f \u043c\u043e\u0432\u0430 \u0456\u0441\u043d\u0443\u0435 \u045e \u043b\u0456\u0442\u0430\u0440\u0430\u0442\u0443\u0440\u043d\u0430\u0439 \u0456 \u0434\u044b\u044f\u043b\u0435\u043a\u0442\u043d\u0430\u0439 \u0444\u043e\u0440\u043c\u0430\u0445."), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u0430 \u043f\u0435\u0440\u0435\u0432\u0456\u0440\u043a\u0438 \u0433\u0440\u0430\u043c\u0430\u0442\u0438\u043a\u0438, \u0441\u0442\u0438\u043b\u044e \u0442\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u0457."), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442 \u0432\u0430\u0448\u0435 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c 20 \u044f\u0437\u044b\u043a\u0430\u0445 - \u041f\u0440\u043e\u0433\u0440\u0430\u043c\u0430 \u043f\u0435\u0440\u0435\u0432\u0456\u0440\u043a\u0438 \u0433\u0440\u0430\u043c\u0430\u0442\u0438\u043a\u0438, \u0441\u0442\u0438\u043b\u044e \u0442\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u0457."), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u0421\u0443\u0447\u0430\u0441\u043d\u0430\u044f \u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f \u043c\u043e\u0432\u0430 \u0456\u0441\u043d\u0443\u0435 \u045e \u043b\u0456\u0442\u0430\u0440\u0430\u0442\u0443\u0440\u043d\u0430\u0439 \u0456 \u0434\u044b\u044f\u043b\u0435\u043a\u0442\u043d\u0430\u0439 \u0444\u043e\u0440\u043c\u0430\u0445. - \u041f\u0440\u043e\u0433\u0440\u0430\u043c\u0430 \u043f\u0435\u0440\u0435\u0432\u0456\u0440\u043a\u0438 \u0433\u0440\u0430\u043c\u0430\u0442\u0438\u043a\u0438, \u0441\u0442\u0438\u043b\u044e \u0442\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u0457."), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442 \u0432\u0430\u0448\u0435 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c 20 \u044f\u0437\u044b\u043a\u0430\u0445 - \u0421\u0443\u0447\u0430\u0441\u043d\u0430\u044f \u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f \u043c\u043e\u0432\u0430 \u0456\u0441\u043d\u0443\u0435 \u045e \u043b\u0456\u0442\u0430\u0440\u0430\u0442\u0443\u0440\u043d\u0430\u0439 \u0456 \u0434\u044b\u044f\u043b\u0435\u043a\u0442\u043d\u0430\u0439 \u0444\u043e\u0440\u043c\u0430\u0445."), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442 \u0432\u0430\u0448\u0435 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c 20 \u044f\u0437\u044b\u043a\u0430\u0445Here's some short English text, but it's short"), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u0430 \u043f\u0435\u0440\u0435\u0432\u0456\u0440\u043a\u0438 \u0433\u0440\u0430\u043c\u0430\u0442\u0438\u043a\u0438, \u0441\u0442\u0438\u043b\u044e \u0442\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u0457.Here's some short English text, but it's short"), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442 \u0432\u0430\u0448\u0435 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c 20 \u044f\u0437\u044b\u043a\u0430\u0445Here's some English text"), (Matcher)CoreMatchers.is((Object)cyrillic));
        Assert.assertThat((Object)this.codes("\u0644\u0650\u064a\u0646\u064f\u0643\u0633 (\u0628\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629: Linux)\u200f (\u0639\u0646 \u0647\u0630\u0627 \u0627\u0644\u0645\u0644\u0641 \u0627\u0633\u062a\u0645\u0639 (\u061f\u00b7\u0645\u0639\u0644\u0648\u0645\u0627\u062a)) \u0648\u064a\u0633\u0645\u0649 \u0623\u064a\u0636\u0627"), (Matcher)CoreMatchers.is((Object)arabic));
        Assert.assertThat((Object)this.codes("\u0637\u0648\u0631 \u0644\u064a\u0646\u0643\u0633 \u0641\u064a \u0627\u0644\u0623\u0635\u0644 \u0644\u0643\u064a \u064a\u0639\u0645\u0644 \u0639\u0644\u0649"), (Matcher)CoreMatchers.is((Object)arabic));
        Assert.assertThat((Object)this.codes("\u064a\u0639\u0645\u0644 \u0644\u064a\u0646\u0643\u0633 \u0623\u064a\u0636\u0627 \u0639\u0644\u0649"), (Matcher)CoreMatchers.is((Object)arabic));
        Assert.assertThat((Object)this.codes("\u0641\u064a \u0628\u0627\u062f\u0626 \u0627\u0644\u0623\u0645\u0631 \u0623\u0631\u0627\u062f"), (Matcher)CoreMatchers.is((Object)arabic));
        Assert.assertThat((Object)this.codes("\u60a8\u7684\u610f\u601d\u662f"), (Matcher)CoreMatchers.is((Object)cjk));
        Assert.assertThat((Object)this.codes("Linux\u56b4\u683c\u4f86\u8aaa\u662f\u55ae\u6307\u4f5c\u696d\u7cfb\u7d71\u7684\u5185\u6838"), (Matcher)CoreMatchers.is((Object)cjk));
        Assert.assertThat((Object)this.codes("\u901a\u5e38\u60c5\u51b5\u4e0b but here's more text with Latin characters"), (Matcher)CoreMatchers.is((Object)"[]"));
        Assert.assertThat((Object)this.codes("Linux\uff08\u30ea\u30ca\u30c3\u30af\u30b9\u3001\u4ed6\u306e\u8aad\u307f\u306f\u5f8c\u8ff0\uff09\u3068\u306f\u3001Unix\u7cfb\u30aa\u30da\u30ec\u30fc\u30c6\u30a3\u30f3\u30b0\u30b7\u30b9\u30c6\u30e0\u30ab\u30fc\u30cd\u30eb"), (Matcher)CoreMatchers.is((Object)cjk));
        Assert.assertThat((Object)this.codes("1990\u5e74\u4ee3\u306fFreeBSD\u3068\u6bd4\u8f03\u3057\u3066\u5b89\u5b9a\u6027\u306b\u52a3\u308b\u3068\u8a00\u308f\u308c\u3066\u304d\u305f\u304c"), (Matcher)CoreMatchers.is((Object)cjk));
        Assert.assertThat((Object)this.codes("\u30ea\u30fc\u30ca\u30b9\u30fb\u30c8\u30fc\u30d0\u30eb\u30ba\u306f\u30ab\u30fc\u30cd\u30eb\u958b"), (Matcher)CoreMatchers.is((Object)cjk));
        Assert.assertThat((Object)this.codes("\u17a0\u17be\u1799\u178a\u17c4\u1799\u200b\u1796\u17d2\u179a\u17c4\u17c7\u200b"), (Matcher)CoreMatchers.is((Object)"[km]"));
        Assert.assertThat((Object)this.codes("\u0bb2\u0bc7\u0b99\u0bcd\u0b95\u0bc1\u0bb5\u0bc7\u0b9c\u0bcd"), (Matcher)CoreMatchers.is((Object)"[ta]"));
        Assert.assertThat((Object)this.codes("\u03a4\u03bf Linux \u03bc\u03c0\u03bf\u03c1\u03b5\u03af \u03bd\u03b1 \u03b5\u03b3\u03ba\u03b1\u03c4\u03b1\u03c3\u03c4\u03b1\u03b8\u03b5\u03af \u03ba\u03b1\u03b9"), (Matcher)CoreMatchers.is((Object)"[el]"));
        Assert.assertThat((Object)this.codes("\u0394\u03b7\u03bc\u03b9\u03bf\u03c5\u03c1\u03b3\u03cc\u03c2 \u03c4\u03bf\u03c5 \u03c0\u03c5\u03c1\u03ae\u03bd\u03b1 Linux \u03b5\u03af\u03bd\u03b1\u03b9 \u03bf"), (Matcher)CoreMatchers.is((Object)"[el]"));
        Assert.assertThat((Object)this.codes("\u039f \u03a4\u03cc\u03c1\u03b2\u03b1\u03bb\u03bd\u03c4\u03c2 \u03be\u03b5\u03ba\u03af\u03bd\u03b7\u03c3\u03b5"), (Matcher)CoreMatchers.is((Object)"[el]"));
        Assert.assertThat((Object)this.codes("\u0926\u0930\u0932\u0948\u0902\u0921 \u092e\u0947\u0902 \u0915\u094b\u0930\u094b\u0928\u094b\u0935\u093e\u092f\u0930\u0938 \u0915\u0947 \u0926\u0930\u094d\u091c \u092e\u093e\u092e\u0932\u094b\u0902 \u0915\u0940 \u0938\u0902\u0916\u094d\u092f\u093e 38 \u0938\u0947 \u092c\u0922\u093c\u0915\u0930 82 \u0939\u094b \u0917\u0908 \u0939\u0948\u0964\n \u092e\u093e\u092e\u0932\u094b\u0902 \u092e\u0947\u0902 \u0935\u0943\u0926\u094d\u0927\u093f \u0924\u092c \u0939\u094b\u0924\u0940 \u0939\u0948 \u091c\u092c \u0926\u0947\u0936 \u0909\u0924\u094d\u0924\u0930\u0940 \u0907\u091f\u0932\u0940 \u092e\u0947\u0902 \u0938\u094d\u0915\u0940\u0907\u0902\u0917 \u0915\u0940 \u091b\u0941\u091f\u094d\u091f\u093f\u092f\u094b\u0902"), (Matcher)CoreMatchers.is((Object)devanagari));
        Assert.assertThat((Object)this.codes("\u0906\u092e\u094d\u0939\u093e\u0932\u093e \u0909\u0936\u0940\u0930 \u0939\u094b\u0923\u093e\u0930 \u0928\u093e\u0939\u0940"), (Matcher)CoreMatchers.is((Object)devanagari));
    }

    private String codes(String s) {
        return this.ident.getAdditionalLangCodes(s).toString();
    }
}

