/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.language.Demo;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleMatcher;
import org.languagetool.rules.patterns.PatternToken;

public class PatternRuleMatcherTest {
    private static JLanguageTool langTool;

    @BeforeClass
    public static void setup() {
        langTool = new JLanguageTool((Language)new Demo());
    }

    @Test
    public void testMatch() throws Exception {
        PatternRuleMatcher matcher = new PatternRuleMatcher(this.getPatternRule("my test"), false);
        this.assertPartialMatch("This is my test.", matcher);
        this.assertNoMatch("This is no test.", matcher);
    }

    @Test
    public void testZeroMinOccurrences() throws Exception {
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMinOccurrence(0);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), patternTokenB, this.makeElement("c"));
        this.assertNoMatch("b a", matcher);
        this.assertNoMatch("c a b", matcher);
        this.assertPartialMatch("b a c", matcher);
        this.assertPartialMatch("a c b", matcher);
        this.assertNoMatch("a b b c", matcher);
        this.assertCompleteMatch("a c", matcher);
        this.assertCompleteMatch("a b c", matcher);
        this.assertNoMatch("a X c", matcher);
        RuleMatch[] matches = this.getMatches("a b c FOO a b c FOO a c a b c", matcher);
        Assert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)4));
        this.assertPosition(matches[0], 0, 5);
        this.assertPosition(matches[1], 10, 15);
        this.assertPosition(matches[2], 20, 23);
        this.assertPosition(matches[3], 24, 29);
    }

    @Test
    public void testTwoZeroMinOccurrences() throws Exception {
        PatternToken patternTokenB1 = this.makeElement("ba");
        patternTokenB1.setMinOccurrence(0);
        PatternToken patternTokenB2 = this.makeElement("bb");
        patternTokenB2.setMinOccurrence(0);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), patternTokenB1, patternTokenB2, this.makeElement("c"));
        this.assertNoMatch("ba a", matcher);
        this.assertNoMatch("c a bb", matcher);
        this.assertPartialMatch("z a c", matcher);
        this.assertPartialMatch("a c z", matcher);
        this.assertNoMatch("a ba ba c", matcher);
        this.assertCompleteMatch("a ba bb c", matcher);
        this.assertCompleteMatch("a ba c", matcher);
        this.assertCompleteMatch("a bb c", matcher);
        this.assertCompleteMatch("a c", matcher);
        this.assertNoMatch("a X c", matcher);
        RuleMatch[] matches = this.getMatches("a ba c FOO a bb c FOO a c a ba bb c", matcher);
        Assert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)4));
        this.assertPosition(matches[0], 0, 6);
        this.assertPosition(matches[1], 11, 17);
        this.assertPosition(matches[2], 22, 25);
        this.assertPosition(matches[3], 26, 35);
    }

    @Test
    public void testZeroMinOccurrences2() throws Exception {
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMinOccurrence(0);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), patternTokenB, this.makeElement("c"), this.makeElement("d"), this.makeElement("e"));
        this.assertCompleteMatch("a b c d e", matcher);
        this.assertCompleteMatch("a c d e", matcher);
        this.assertNoMatch("a d", matcher);
        this.assertNoMatch("a c b d", matcher);
        this.assertNoMatch("a c b d e", matcher);
    }

    @Test
    public void testZeroMinOccurrences3() throws Exception {
        PatternToken patternTokenC = this.makeElement("c");
        patternTokenC.setMinOccurrence(0);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), this.makeElement("b"), patternTokenC, this.makeElement("d"), this.makeElement("e"));
        this.assertCompleteMatch("a b c d e", matcher);
        this.assertCompleteMatch("a b d e", matcher);
        this.assertPartialMatch("a b c d e x", matcher);
        this.assertPartialMatch("x a b c d e", matcher);
        this.assertNoMatch("a b c e d", matcher);
        this.assertNoMatch("a c b d e", matcher);
    }

    @Test
    public void testZeroMinOccurrences4() throws Exception {
        PatternToken patternTokenA = this.makeElement("a");
        patternTokenA.setMinOccurrence(0);
        PatternToken patternTokenC = this.makeElement("c");
        patternTokenC.setMinOccurrence(0);
        PatternRuleMatcher matcher = this.getMatcher(patternTokenA, this.makeElement("b"), patternTokenC, this.makeElement("d"), this.makeElement("e"));
        RuleMatch[] matches = this.getMatches("a b c d e", matcher);
        Assert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches[0], 0, 9);
    }

    @Test
    public void testZeroMinOccurrencesWithEmptyElement() throws Exception {
        PatternToken patternTokenB = this.makeElement(null);
        patternTokenB.setMinOccurrence(0);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), patternTokenB, this.makeElement("c"));
        this.assertNoMatch("b a", matcher);
        this.assertNoMatch("c a b", matcher);
        this.assertPartialMatch("b a c", matcher);
        this.assertPartialMatch("a c b", matcher);
        this.assertNoMatch("a b b c", matcher);
        this.assertCompleteMatch("a c", matcher);
        this.assertCompleteMatch("a b c", matcher);
        this.assertCompleteMatch("a X c", matcher);
        RuleMatch[] matches = this.getMatches("a b c FOO a X c", matcher);
        Assert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)2));
        this.assertPosition(matches[0], 0, 5);
        this.assertPosition(matches[1], 10, 15);
    }

    @Test
    public void testZeroMinOccurrencesWithSuggestion() throws Exception {
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMinOccurrence(0);
        List<PatternToken> patternTokens = Arrays.asList(this.makeElement("a"), patternTokenB, this.makeElement("c"));
        PatternRule rule = new PatternRule("", (Language)new Demo(), patternTokens, "my description", "<suggestion>\\1 \\2 \\3</suggestion>", "short message");
        PatternRuleMatcher matcher = new PatternRuleMatcher(rule, false);
        rule.addSuggestionMatch(new Match(null, null, false, null, null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE));
        RuleMatch[] matches = this.getMatches("a b c", matcher);
        Assert.assertEquals(Arrays.asList("a b c"), (Object)matches[0].getSuggestedReplacements());
        RuleMatch[] matches2 = this.getMatches("a c", matcher);
        Assert.assertEquals(Arrays.asList("a c"), (Object)matches2[0].getSuggestedReplacements());
    }

    @Test
    @Ignore(value="min can only be 0 or 1 so far")
    public void testTwoMinOccurrences() throws Exception {
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMinOccurrence(2);
        patternTokenB.setMaxOccurrence(3);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), patternTokenB, this.makeElement("c"));
        this.assertCompleteMatch("a b b c", matcher);
        this.assertCompleteMatch("a b b b c", matcher);
        this.assertNoMatch("a c", matcher);
        this.assertNoMatch("a b c", matcher);
    }

    @Test
    public void testZeroMinTwoMaxOccurrences() throws Exception {
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMinOccurrence(0);
        patternTokenB.setMaxOccurrence(2);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), patternTokenB, this.makeElement("c"));
        this.assertCompleteMatch("a c", matcher);
        this.assertCompleteMatch("a  b c", matcher);
        this.assertCompleteMatch("a  b b c", matcher);
        this.assertNoMatch("a b b b c", matcher);
    }

    @Test
    public void testTwoMaxOccurrencesWithAnyToken() throws Exception {
        PatternToken anyPatternToken = this.makeElement(null);
        anyPatternToken.setMaxOccurrence(2);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), anyPatternToken, this.makeElement("c"));
        this.assertCompleteMatch("a b c", matcher);
        this.assertCompleteMatch("a b b c", matcher);
        this.assertNoMatch("a b b b c", matcher);
    }

    @Test
    public void testThreeMaxOccurrencesWithAnyToken() throws Exception {
        PatternToken anyPatternToken = this.makeElement(null);
        anyPatternToken.setMaxOccurrence(3);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), anyPatternToken, this.makeElement("c"));
        this.assertCompleteMatch("a b c", matcher);
        this.assertCompleteMatch("a b b c", matcher);
        this.assertCompleteMatch("a b b b c", matcher);
        this.assertNoMatch("a b b b b c", matcher);
    }

    @Test
    public void testZeroMinTwoMaxOccurrencesWithAnyToken() throws Exception {
        PatternToken anyPatternToken = this.makeElement(null);
        anyPatternToken.setMinOccurrence(0);
        anyPatternToken.setMaxOccurrence(2);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), anyPatternToken, this.makeElement("c"));
        this.assertNoMatch("a b", matcher);
        this.assertNoMatch("b c", matcher);
        this.assertNoMatch("c", matcher);
        this.assertNoMatch("a", matcher);
        this.assertCompleteMatch("a c", matcher);
        this.assertCompleteMatch("a x c", matcher);
        this.assertCompleteMatch("a x x c", matcher);
        this.assertNoMatch("a x x x c", matcher);
    }

    @Test
    public void testTwoMaxOccurrences() throws Exception {
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMaxOccurrence(2);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), patternTokenB);
        this.assertNoMatch("a a", matcher);
        this.assertCompleteMatch("a b", matcher);
        this.assertCompleteMatch("a b b", matcher);
        this.assertPartialMatch("a b c", matcher);
        this.assertPartialMatch("a b b c", matcher);
        this.assertPartialMatch("x a b b", matcher);
        RuleMatch[] matches1 = this.getMatches("a b b b", matcher);
        Assert.assertThat((Object)matches1.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches1[0], 0, 5);
        RuleMatch[] matches2 = this.getMatches("a b b b foo a b b", matcher);
        Assert.assertThat((Object)matches2.length, (Matcher)CoreMatchers.is((Object)2));
        this.assertPosition(matches2[0], 0, 5);
        this.assertPosition(matches2[1], 12, 17);
    }

    @Test
    public void testThreeMaxOccurrences() throws Exception {
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMaxOccurrence(3);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), patternTokenB);
        this.assertNoMatch("a a", matcher);
        this.assertCompleteMatch("a b", matcher);
        this.assertCompleteMatch("a b b", matcher);
        this.assertCompleteMatch("a b b b", matcher);
        this.assertPartialMatch("a b b b b", matcher);
        RuleMatch[] matches1 = this.getMatches("a b b b b", matcher);
        Assert.assertThat((Object)matches1.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches1[0], 0, 7);
    }

    @Test
    public void testOptionalWithoutExplicitMarker() throws Exception {
        PatternToken patternTokenA = this.makeElement("a");
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMinOccurrence(0);
        PatternToken patternTokenC = this.makeElement("c");
        PatternRuleMatcher matcher = this.getMatcher(patternTokenA, patternTokenB, patternTokenC);
        RuleMatch[] matches1 = this.getMatches("A B C ZZZ", matcher);
        Assert.assertThat((Object)matches1.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches1[0], 0, 5);
        RuleMatch[] matches2 = this.getMatches("A C ZZZ", matcher);
        Assert.assertThat((Object)matches2.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches2[0], 0, 3);
    }

    @Test
    public void testOptionalWithExplicitMarker() throws Exception {
        PatternToken patternTokenA = this.makeElement("a");
        patternTokenA.setInsideMarker(true);
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMinOccurrence(0);
        patternTokenB.setInsideMarker(true);
        PatternToken patternTokenC = this.makeElement("c");
        patternTokenC.setInsideMarker(false);
        PatternRuleMatcher matcher = this.getMatcher(patternTokenA, patternTokenB, patternTokenC);
        RuleMatch[] matches1 = this.getMatches("A B C ZZZ", matcher);
        Assert.assertThat((Object)matches1.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches1[0], 0, 3);
        RuleMatch[] matches2 = this.getMatches("A C ZZZ", matcher);
        Assert.assertThat((Object)matches2.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches2[0], 0, 1);
    }

    @Test
    public void testOptionalAnyTokenWithExplicitMarker() throws Exception {
        PatternToken patternTokenA = this.makeElement("a");
        patternTokenA.setInsideMarker(true);
        PatternToken patternTokenB = this.makeElement(null);
        patternTokenB.setMinOccurrence(0);
        patternTokenB.setInsideMarker(true);
        PatternToken patternTokenC = this.makeElement("c");
        patternTokenC.setInsideMarker(false);
        PatternRuleMatcher matcher = this.getMatcher(patternTokenA, patternTokenB, patternTokenC);
        RuleMatch[] matches1 = this.getMatches("A x C ZZZ", matcher);
        Assert.assertThat((Object)matches1.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches1[0], 0, 3);
        RuleMatch[] matches2 = this.getMatches("A C ZZZ", matcher);
        Assert.assertThat((Object)matches2.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches2[0], 0, 1);
    }

    @Test
    public void testOptionalAnyTokenWithExplicitMarker2() throws Exception {
        PatternToken patternTokenA = this.makeElement("the");
        patternTokenA.setInsideMarker(true);
        PatternToken patternTokenB = this.makeElement(null);
        patternTokenB.setMinOccurrence(0);
        patternTokenB.setInsideMarker(true);
        PatternToken patternTokenC = this.makeElement("bike");
        patternTokenC.setInsideMarker(false);
        PatternRuleMatcher matcher = this.getMatcher(patternTokenA, patternTokenB, patternTokenC);
        RuleMatch[] matches1 = this.getMatches("the nice bike ZZZ", matcher);
        Assert.assertThat((Object)matches1.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches1[0], 0, 8);
        RuleMatch[] matches2 = this.getMatches("the bike ZZZ", matcher);
        Assert.assertThat((Object)matches2.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches2[0], 0, 3);
    }

    @Test
    public void testUnlimitedMaxOccurrences() throws Exception {
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMaxOccurrence(-1);
        PatternRuleMatcher matcher = this.getMatcher(this.makeElement("a"), patternTokenB, this.makeElement("c"));
        this.assertNoMatch("a c", matcher);
        this.assertNoMatch("a b", matcher);
        this.assertNoMatch("b c", matcher);
        this.assertCompleteMatch("a b c", matcher);
        this.assertCompleteMatch("a b b c", matcher);
        this.assertCompleteMatch("a b b b b b b b b b b b b b b b b b b b b b b b b b c", matcher);
    }

    @Test
    public void testMaxTwoAndThreeOccurrences() throws Exception {
        PatternToken patternTokenA = this.makeElement("a");
        patternTokenA.setMaxOccurrence(2);
        PatternToken patternTokenB = this.makeElement("b");
        patternTokenB.setMaxOccurrence(3);
        PatternRuleMatcher matcher = this.getMatcher(patternTokenA, patternTokenB);
        this.assertCompleteMatch("a b", matcher);
        this.assertCompleteMatch("a b b", matcher);
        this.assertCompleteMatch("a b b b", matcher);
        this.assertNoMatch("a a", matcher);
        this.assertNoMatch("a x b b b", matcher);
        RuleMatch[] matches2 = this.getMatches("a a b", matcher);
        Assert.assertThat((Object)matches2.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches2[0], 0, 5);
        RuleMatch[] matches3 = this.getMatches("a a b b", matcher);
        Assert.assertThat((Object)matches3.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches3[0], 0, 7);
        RuleMatch[] matches4 = this.getMatches("a a b b b", matcher);
        Assert.assertThat((Object)matches4.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches4[0], 0, 9);
    }

    @Test
    public void testInfiniteSkip() throws Exception {
        PatternToken patternTokenA = this.makeElement("a");
        patternTokenA.setSkipNext(-1);
        PatternRuleMatcher matcher = this.getMatcher(patternTokenA, this.makeElement("b"));
        this.assertCompleteMatch("a b", matcher);
        this.assertCompleteMatch("a x b", matcher);
        this.assertCompleteMatch("a x x b", matcher);
        this.assertCompleteMatch("a x x x b", matcher);
    }

    @Test
    public void testInfiniteSkipWithMatchReference() throws Exception {
        PatternToken patternTokenAB = new PatternToken("a|b", false, true, false);
        patternTokenAB.setSkipNext(-1);
        PatternToken patternTokenC = this.makeElement("\\0");
        Match match = new Match(null, null, false, null, null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
        match.setTokenRef(0);
        match.setInMessageOnly(true);
        patternTokenC.setMatch(match);
        PatternRuleMatcher matcher = this.getMatcher(patternTokenAB, patternTokenC);
        this.assertCompleteMatch("a a", matcher);
        this.assertCompleteMatch("b b", matcher);
        this.assertCompleteMatch("a x a", matcher);
        this.assertCompleteMatch("b x b", matcher);
        this.assertCompleteMatch("a x x a", matcher);
        this.assertCompleteMatch("b x x b", matcher);
        this.assertNoMatch("a b", matcher);
        this.assertNoMatch("b a", matcher);
        this.assertNoMatch("b x a", matcher);
        this.assertNoMatch("b x a", matcher);
        this.assertNoMatch("a x x b", matcher);
        this.assertNoMatch("b x x a", matcher);
        RuleMatch[] matches = this.getMatches("a foo a and b foo b", matcher);
        Assert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)2));
        this.assertPosition(matches[0], 0, 7);
        this.assertPosition(matches[1], 12, 19);
        RuleMatch[] matches2 = this.getMatches("xx a b x x x b a", matcher);
        Assert.assertThat((Object)matches2.length, (Matcher)CoreMatchers.is((Object)1));
        this.assertPosition(matches2[0], 3, 16);
    }

    @Test
    public void testNoMatchReferenceRecursion() throws IOException {
        PatternRule rule = new PatternRule("MATCH_REFERENCERE_CURSION_DEMO", (Language)new Demo(), Arrays.asList(new PatternToken("\\p{Punct}", false, true, false), new PatternToken("\\d+", false, true, false)), "", "Here come the match references: \\1\\2. This is the end", "");
        PatternRuleMatcher matcher = new PatternRuleMatcher(rule, false);
        RuleMatch[] matches = this.getMatches(":42", matcher);
        Assert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)matches[0].getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Here come the match references: :42. This is the end"));
        RuleMatch[] matches2 = this.getMatches("\\42", matcher);
        Assert.assertThat((Object)matches2.length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)matches2[0].getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Here come the match references: \\42. This is the end"));
    }

    @Test
    public void testEquals() throws Exception {
        PatternRule patternRule1 = new PatternRule("id1", Languages.getLanguageForShortCode((String)"xx"), Collections.emptyList(), "desc1", "msg1", "short1");
        RuleMatch ruleMatch1 = new RuleMatch((Rule)patternRule1, null, 0, 1, "message");
        RuleMatch ruleMatch2 = new RuleMatch((Rule)patternRule1, null, 0, 1, "message");
        Assert.assertTrue((boolean)ruleMatch1.equals((Object)ruleMatch2));
        RuleMatch ruleMatch3 = new RuleMatch((Rule)patternRule1, null, 0, 9, "message");
        Assert.assertFalse((boolean)ruleMatch1.equals((Object)ruleMatch3));
        Assert.assertFalse((boolean)ruleMatch2.equals((Object)ruleMatch3));
    }

    private RuleMatch[] getMatches(String input, PatternRuleMatcher matcher) throws IOException {
        return matcher.match(langTool.getAnalyzedSentence(input));
    }

    private PatternRuleMatcher getMatcher(PatternToken ... patternPatternTokens) {
        return new PatternRuleMatcher(this.getPatternRule(Arrays.asList(patternPatternTokens)), false);
    }

    private void assertPosition(RuleMatch match, int expectedFromPos, int expectedToPos) {
        Assert.assertThat((String)"Wrong start position", (Object)match.getFromPos(), (Matcher)CoreMatchers.is((Object)expectedFromPos));
        Assert.assertThat((String)"Wrong end position", (Object)match.getToPos(), (Matcher)CoreMatchers.is((Object)expectedToPos));
    }

    private void assertNoMatch(String input, PatternRuleMatcher matcher) throws IOException {
        RuleMatch[] matches = this.getMatches(input, matcher);
        Assert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)0));
    }

    private void assertPartialMatch(String input, PatternRuleMatcher matcher) throws IOException {
        RuleMatch[] matches = this.getMatches(input, matcher);
        Assert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((String)("Expected partial match, got '" + matches[0] + "' for '" + input + "'"), (matches[0].getFromPos() > 0 || matches[0].getToPos() < input.length() ? 1 : 0) != 0);
    }

    private void assertCompleteMatch(String input, PatternRuleMatcher matcher) throws IOException {
        Object[] matches = this.getMatches(input, matcher);
        Assert.assertThat((String)("Got matches: " + Arrays.toString(matches)), (Object)matches.length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong start position", (Object)matches[0].getFromPos(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((String)"Wrong end position", (Object)matches[0].getToPos(), (Matcher)CoreMatchers.is((Object)input.length()));
    }

    private PatternToken makeElement(String token) {
        return new PatternToken(token, false, false, false);
    }

    private PatternRule getPatternRule(String pattern) {
        String[] parts = pattern.split(" ");
        ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
        for (String part : parts) {
            patternTokens.add(new PatternToken(part, false, false, false));
        }
        return this.getPatternRule(patternTokens);
    }

    private PatternRule getPatternRule(List<PatternToken> patternTokens) {
        return new PatternRule("", (Language)new Demo(), patternTokens, "my description", "my message", "short message");
    }
}

