/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.TestTools;
import org.languagetool.XMLValidator;
import org.languagetool.rules.patterns.PatternTestTools;
import org.languagetool.tagging.disambiguation.rules.DisambiguatedExample;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tagging.disambiguation.rules.DisambiguationRuleLoader;
import org.languagetool.tagging.disambiguation.xx.DemoDisambiguator;
import org.xml.sax.SAXException;

public class DisambiguationRuleTest {
    @Test
    public void testDisambiguationRulesFromXML() throws Exception {
        this.testDisambiguationRulesFromXML(null);
    }

    private void testDisambiguationRulesFromXML(Set<Language> ignoredLanguages) throws IOException, ParserConfigurationException, SAXException {
        for (Language lang : Languages.getWithDemoLanguage()) {
            if (ignoredLanguages != null && ignoredLanguages.contains(lang)) continue;
            if (lang.isVariant()) {
                System.out.println("Skipping variant: " + lang);
                continue;
            }
            System.out.println("Running disambiguation tests for " + lang.getName() + "...");
            DisambiguationRuleLoader ruleLoader = new DisambiguationRuleLoader();
            JLanguageTool lt = new JLanguageTool(lang);
            if (lt.getLanguage().getDisambiguator() instanceof DemoDisambiguator) continue;
            long startTime = System.currentTimeMillis();
            String name = JLanguageTool.getDataBroker().getResourceDir() + "/" + lang.getShortCode() + "/disambiguation.xml";
            this.validateRuleFile(name);
            List rules = ruleLoader.getRules(ruleLoader.getClass().getResourceAsStream(name));
            for (DisambiguationPatternRule rule : rules) {
                PatternTestTools.warnIfRegexpSyntaxNotKosher(rule.getPatternTokens(), rule.getId(), rule.getSubId(), lang);
            }
            this.testDisambiguationRulesFromXML(rules, lt, lang);
            long endTime = System.currentTimeMillis();
            System.out.println(rules.size() + " rules tested (" + (endTime - startTime) + "ms)");
        }
    }

    private void validateRuleFile(String filePath) throws IOException {
        XMLValidator validator = new XMLValidator();
        try (InputStream stream = this.getClass().getResourceAsStream(filePath);){
            if (stream != null) {
                validator.validateWithXmlSchema(filePath, JLanguageTool.getDataBroker().getResourceDir() + "/disambiguation.xsd");
            }
        }
    }

    private static String sortForms(String wordForms) {
        if (",[,]".equals(wordForms)) {
            return wordForms;
        }
        String word = wordForms.substring(0, wordForms.indexOf(91) + 1);
        String forms = wordForms.substring(wordForms.indexOf(91) + 1, wordForms.length() - 1);
        Object[] formToSort = forms.split(",");
        Arrays.sort(formToSort);
        return word + String.join((CharSequence)",", Arrays.asList(formToSort)) + "]";
    }

    private void testDisambiguationRulesFromXML(List<DisambiguationPatternRule> rules, JLanguageTool lt, Language lang) throws IOException {
        int i = 0;
        for (DisambiguationPatternRule rule : rules) {
            List examples;
            if (++i % 100 == 0) {
                System.out.println(i + "...");
            }
            String id = rule.getId();
            if (rule.getUntouchedExamples() != null) {
                List goodSentences = rule.getUntouchedExamples();
                for (String goodSentence : goodSentences) {
                    goodSentence = goodSentence.replaceAll("[\\n\\t]+", "");
                    Assert.assertTrue(((goodSentence = DisambiguationRuleTest.cleanXML(goodSentence)).trim().length() > 0 ? 1 : 0) != 0);
                    AnalyzedSentence sent = this.disambiguateUntil(lang, rules, id, lt.getRawAnalyzedSentence(goodSentence));
                    AnalyzedSentence sentToReplace = this.disambiguateUntil(lang, rules, id, lt.getRawAnalyzedSentence(goodSentence));
                    Assert.assertEquals((String)("The untouched example (" + goodSentence + ") for " + lang.getName() + " rule " + rule + "] was touched!"), (Object)sent.toString(), (Object)rule.replace(sentToReplace).toString());
                }
            }
            if ((examples = rule.getExamples()) == null) continue;
            for (DisambiguatedExample example : examples) {
                AnalyzedTokenReadings[] r;
                String outputForms = example.getDisambiguated();
                Assert.assertTrue((String)("No output form found for: " + id), (outputForms != null ? 1 : 0) != 0);
                Assert.assertTrue((String)"Output form must not be empty", (outputForms.trim().length() > 0 ? 1 : 0) != 0);
                int expectedMatchStart = example.getExample().indexOf("<marker>");
                int expectedMatchEnd = example.getExample().indexOf("</marker>") - "<marker>".length();
                if (expectedMatchStart == -1 || expectedMatchEnd == -1) {
                    Assert.fail((String)(lang + ": No position markup ('<marker>...</marker>') in disambiguated example in rule " + rule));
                }
                String inputForms = example.getAmbiguous();
                Assert.assertTrue((String)("No input form found for: " + id), (inputForms != null ? 1 : 0) != 0);
                Assert.assertTrue((inputForms.trim().length() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Input and output forms for rule " + id + " are the same!"), (!outputForms.equals(inputForms) ? 1 : 0) != 0);
                AnalyzedSentence cleanInput = lt.getRawAnalyzedSentence(DisambiguationRuleTest.cleanXML(example.getExample()));
                AnalyzedSentence sent = this.disambiguateUntil(lang, rules, id, lt.getRawAnalyzedSentence(DisambiguationRuleTest.cleanXML(example.getExample())));
                AnalyzedSentence disambiguatedSent = rule.replace(this.disambiguateUntil(lang, rules, id, lt.getRawAnalyzedSentence(DisambiguationRuleTest.cleanXML(example.getExample()))));
                Assert.assertTrue((String)("Disambiguated sentence is equal to the non-disambiguated sentence for rule: " + id + ". The sentence was: " + sent), (!cleanInput.equals((Object)disambiguatedSent) ? 1 : 0) != 0);
                Assert.assertTrue((String)("Disambiguated sentence is equal to the input sentence for rule: " + id + ". The sentence was: " + sent), (!sent.equals((Object)disambiguatedSent) ? 1 : 0) != 0);
                String reading = "";
                String annotations = "";
                for (AnalyzedTokenReadings readings : sent.getTokens()) {
                    if (readings.isSentenceStart() && !inputForms.contains("<S>") || readings.getStartPos() != expectedMatchStart) continue;
                    r = new AnalyzedTokenReadings[]{readings};
                    reading = new AnalyzedSentence(r).toShortString(",");
                    annotations = readings.getHistoricalAnnotations();
                    int startPos = readings.getStartPos();
                    int endPos = readings.getEndPos();
                    Assert.assertTrue((String)("Wrong marker position in the example for the rule " + id + ": got " + startPos + "-" + endPos + ", expected " + expectedMatchStart + "-" + expectedMatchEnd), (startPos == expectedMatchStart && endPos == expectedMatchEnd ? 1 : 0) != 0);
                    break;
                }
                Assert.assertEquals((String)("The input form for the rule " + id + " in the example: " + example + " is different than expected (expected " + inputForms + " but got " + DisambiguationRuleTest.sortForms(reading) + "). The token has been changed by the disambiguator: " + annotations), (Object)inputForms, (Object)DisambiguationRuleTest.sortForms(reading));
                for (AnalyzedTokenReadings readings : disambiguatedSent.getTokens()) {
                    if (readings.isSentenceStart() && !outputForms.contains("<S>") || readings.getStartPos() != expectedMatchStart) continue;
                    r = new AnalyzedTokenReadings[]{readings};
                    reading = new AnalyzedSentence(r).toShortString(",");
                    Assert.assertTrue((readings.getStartPos() == expectedMatchStart && readings.getEndPos() == expectedMatchEnd ? 1 : 0) != 0);
                    break;
                }
                Assert.assertEquals((String)("The output form for the rule " + id + " in the example: " + example + " is different than expected (expected " + outputForms + " but got " + DisambiguationRuleTest.sortForms(reading) + "). The token has been changed by the disambiguator: " + annotations), (Object)outputForms, (Object)DisambiguationRuleTest.sortForms(reading));
            }
        }
    }

    private AnalyzedSentence disambiguateUntil(Language lang, List<DisambiguationPatternRule> rules, String ruleID, AnalyzedSentence sentence) throws IOException {
        AnalyzedSentence disambiguated = sentence;
        disambiguated = lang.getDisambiguator().preDisambiguate(disambiguated);
        for (DisambiguationPatternRule rule : rules) {
            if (ruleID.equals(rule.getId())) break;
            disambiguated = rule.replace(disambiguated);
        }
        return disambiguated;
    }

    private static String cleanXML(String str) {
        return str.replaceAll("<.*?>", "");
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        DisambiguationRuleTest test = new DisambiguationRuleTest();
        System.out.println("Running disambiguator rule tests...");
        if (args.length == 0) {
            test.testDisambiguationRulesFromXML(null);
        } else {
            Set<Language> ignoredLanguages = TestTools.getLanguagesExcept(args);
            test.testDisambiguationRulesFromXML(ignoredLanguages);
        }
        System.out.println("Disambiguator tests successful.");
    }
}

