/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.FakeLanguage;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.tools.StringTools;

public class StringToolsTest {
    @Test
    public void testAssureSet() {
        try {
            StringTools.assureSet((String)"", (String)"varName");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StringTools.assureSet((String)" \t", (String)"varName");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StringTools.assureSet(null, (String)"varName");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        StringTools.assureSet((String)"foo", (String)"varName");
    }

    @Test
    public void testReadStream() throws IOException {
        String content = StringTools.readStream((InputStream)new FileInputStream("src/test/resources/testinput.txt"), (String)"utf-8");
        Assert.assertEquals((Object)"one\ntwo\n\u00f6\u00e4\u00fc\u00df\n\u0219\u021b\u00ee\u00e2\u0103\u0218\u021a\u00ce\u00c2\u0102\n", (Object)content);
    }

    @Test
    public void testIsAllUppercase() {
        Assert.assertTrue((boolean)StringTools.isAllUppercase((String)"A"));
        Assert.assertTrue((boolean)StringTools.isAllUppercase((String)"ABC"));
        Assert.assertTrue((boolean)StringTools.isAllUppercase((String)"ASV-EDR"));
        Assert.assertTrue((boolean)StringTools.isAllUppercase((String)"ASV-\u00d6\u00c4\u00dc"));
        Assert.assertTrue((boolean)StringTools.isAllUppercase((String)""));
        Assert.assertFalse((boolean)StringTools.isAllUppercase((String)"\u00df"));
        Assert.assertFalse((boolean)StringTools.isAllUppercase((String)"AAAAAAAAAAAAq"));
        Assert.assertFalse((boolean)StringTools.isAllUppercase((String)"a"));
        Assert.assertFalse((boolean)StringTools.isAllUppercase((String)"abc"));
    }

    @Test
    public void testIsMixedCase() {
        Assert.assertTrue((boolean)StringTools.isMixedCase((String)"AbC"));
        Assert.assertTrue((boolean)StringTools.isMixedCase((String)"MixedCase"));
        Assert.assertTrue((boolean)StringTools.isMixedCase((String)"iPod"));
        Assert.assertTrue((boolean)StringTools.isMixedCase((String)"AbCdE"));
        Assert.assertFalse((boolean)StringTools.isMixedCase((String)""));
        Assert.assertFalse((boolean)StringTools.isMixedCase((String)"ABC"));
        Assert.assertFalse((boolean)StringTools.isMixedCase((String)"abc"));
        Assert.assertFalse((boolean)StringTools.isMixedCase((String)"!"));
        Assert.assertFalse((boolean)StringTools.isMixedCase((String)"Word"));
    }

    @Test
    public void testIsCapitalizedWord() {
        Assert.assertTrue((boolean)StringTools.isCapitalizedWord((String)"Abc"));
        Assert.assertTrue((boolean)StringTools.isCapitalizedWord((String)"Uppercase"));
        Assert.assertTrue((boolean)StringTools.isCapitalizedWord((String)"Ipod"));
        Assert.assertFalse((boolean)StringTools.isCapitalizedWord((String)""));
        Assert.assertFalse((boolean)StringTools.isCapitalizedWord((String)"ABC"));
        Assert.assertFalse((boolean)StringTools.isCapitalizedWord((String)"abc"));
        Assert.assertFalse((boolean)StringTools.isCapitalizedWord((String)"!"));
        Assert.assertFalse((boolean)StringTools.isCapitalizedWord((String)"wOrD"));
    }

    @Test
    public void testStartsWithUppercase() {
        Assert.assertTrue((boolean)StringTools.startsWithUppercase((String)"A"));
        Assert.assertTrue((boolean)StringTools.startsWithUppercase((String)"\u00c4\u00d6"));
        Assert.assertFalse((boolean)StringTools.startsWithUppercase((String)""));
        Assert.assertFalse((boolean)StringTools.startsWithUppercase((String)"\u00df"));
        Assert.assertFalse((boolean)StringTools.startsWithUppercase((String)"-"));
    }

    @Test
    public void testUppercaseFirstChar() {
        Assert.assertEquals(null, (Object)StringTools.uppercaseFirstChar(null));
        Assert.assertEquals((Object)"", (Object)StringTools.uppercaseFirstChar((String)""));
        Assert.assertEquals((Object)"A", (Object)StringTools.uppercaseFirstChar((String)"A"));
        Assert.assertEquals((Object)"\u00d6\u00e4\u00fc", (Object)StringTools.uppercaseFirstChar((String)"\u00f6\u00e4\u00fc"));
        Assert.assertEquals((Object)"\u00dfa", (Object)StringTools.uppercaseFirstChar((String)"\u00dfa"));
        Assert.assertEquals((Object)"'Test'", (Object)StringTools.uppercaseFirstChar((String)"'test'"));
        Assert.assertEquals((Object)"''Test", (Object)StringTools.uppercaseFirstChar((String)"''test"));
        Assert.assertEquals((Object)"''T", (Object)StringTools.uppercaseFirstChar((String)"''t"));
        Assert.assertEquals((Object)"'''", (Object)StringTools.uppercaseFirstChar((String)"'''"));
    }

    @Test
    public void testLowercaseFirstChar() {
        Assert.assertEquals(null, (Object)StringTools.lowercaseFirstChar(null));
        Assert.assertEquals((Object)"", (Object)StringTools.lowercaseFirstChar((String)""));
        Assert.assertEquals((Object)"a", (Object)StringTools.lowercaseFirstChar((String)"A"));
        Assert.assertEquals((Object)"\u00f6\u00e4\u00fc", (Object)StringTools.lowercaseFirstChar((String)"\u00d6\u00e4\u00fc"));
        Assert.assertEquals((Object)"\u00dfa", (Object)StringTools.lowercaseFirstChar((String)"\u00dfa"));
        Assert.assertEquals((Object)"'test'", (Object)StringTools.lowercaseFirstChar((String)"'Test'"));
        Assert.assertEquals((Object)"''test", (Object)StringTools.lowercaseFirstChar((String)"''Test"));
        Assert.assertEquals((Object)"''t", (Object)StringTools.lowercaseFirstChar((String)"''T"));
        Assert.assertEquals((Object)"'''", (Object)StringTools.lowercaseFirstChar((String)"'''"));
    }

    @Test
    public void testReaderToString() throws IOException {
        String str = StringTools.readerToString((Reader)new StringReader("bla\n\u00f6\u00e4\u00fc"));
        Assert.assertEquals((Object)"bla\n\u00f6\u00e4\u00fc", (Object)str);
        StringBuilder longStr = new StringBuilder();
        for (int i = 0; i < 4000; ++i) {
            longStr.append('x');
        }
        longStr.append("1234567");
        Assert.assertEquals((long)4007L, (long)longStr.length());
        String str2 = StringTools.readerToString((Reader)new StringReader(longStr.toString()));
        Assert.assertEquals((Object)longStr.toString(), (Object)str2);
    }

    @Test
    public void testEscapeXMLandHTML() {
        Assert.assertEquals((Object)"foo bar", (Object)StringTools.escapeXML((String)"foo bar"));
        Assert.assertEquals((Object)"!\u00e4&quot;&lt;&gt;&amp;&amp;", (Object)StringTools.escapeXML((String)"!\u00e4\"<>&&"));
        Assert.assertEquals((Object)"!\u00e4&quot;&lt;&gt;&amp;&amp;", (Object)StringTools.escapeHTML((String)"!\u00e4\"<>&&"));
    }

    @Test
    public void testListToString() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        list.add(",");
        Assert.assertEquals((Object)"foo,bar,,", (Object)String.join((CharSequence)",", list));
        Assert.assertEquals((Object)"foo\tbar\t,", (Object)String.join((CharSequence)"\t", list));
    }

    @Test
    public void testTrimWhitespace() {
        try {
            Assert.assertEquals(null, (Object)StringTools.trimWhitespace(null));
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"", (Object)StringTools.trimWhitespace((String)""));
        Assert.assertEquals((Object)"", (Object)StringTools.trimWhitespace((String)" "));
        Assert.assertEquals((Object)"XXY", (Object)StringTools.trimWhitespace((String)" \nXX\t Y"));
        Assert.assertEquals((Object)"XXY", (Object)StringTools.trimWhitespace((String)" \r\nXX\t Y"));
        Assert.assertEquals((Object)"word", (Object)StringTools.trimWhitespace((String)"word"));
        Assert.assertEquals((Object)"1 234,56", (Object)StringTools.trimWhitespace((String)"1 234,56"));
        Assert.assertEquals((Object)"1234,56", (Object)StringTools.trimWhitespace((String)"1  234,56"));
    }

    @Test
    public void testAddSpace() {
        Language demoLanguage = TestTools.getDemoLanguage();
        Assert.assertEquals((Object)" ", (Object)StringTools.addSpace((String)"word", (Language)demoLanguage));
        Assert.assertEquals((Object)"", (Object)StringTools.addSpace((String)",", (Language)demoLanguage));
        Assert.assertEquals((Object)"", (Object)StringTools.addSpace((String)",", (Language)demoLanguage));
        Assert.assertEquals((Object)"", (Object)StringTools.addSpace((String)",", (Language)demoLanguage));
        Assert.assertEquals((Object)"", (Object)StringTools.addSpace((String)".", (Language)new FakeLanguage("fr")));
        Assert.assertEquals((Object)"", (Object)StringTools.addSpace((String)".", (Language)new FakeLanguage("de")));
        Assert.assertEquals((Object)" ", (Object)StringTools.addSpace((String)"!", (Language)new FakeLanguage("fr")));
        Assert.assertEquals((Object)"", (Object)StringTools.addSpace((String)"!", (Language)new FakeLanguage("de")));
    }

    @Test
    public void testIsWhitespace() {
        Assert.assertEquals((Object)true, (Object)StringTools.isWhitespace((String)"\ufeff"));
        Assert.assertEquals((Object)true, (Object)StringTools.isWhitespace((String)"  "));
        Assert.assertEquals((Object)true, (Object)StringTools.isWhitespace((String)"\t"));
        Assert.assertEquals((Object)true, (Object)StringTools.isWhitespace((String)"\u2002"));
        Assert.assertEquals((Object)true, (Object)StringTools.isWhitespace((String)"\u00a0"));
        Assert.assertEquals((Object)false, (Object)StringTools.isWhitespace((String)"abc"));
        Assert.assertEquals((Object)false, (Object)StringTools.isWhitespace((String)"\\u02"));
        Assert.assertEquals((Object)false, (Object)StringTools.isWhitespace((String)"\u0001"));
        Assert.assertEquals((Object)true, (Object)StringTools.isWhitespace((String)"\u202f"));
    }

    @Test
    public void testIsPositiveNumber() {
        Assert.assertEquals((Object)true, (Object)StringTools.isPositiveNumber((char)'3'));
        Assert.assertEquals((Object)false, (Object)StringTools.isPositiveNumber((char)'a'));
    }

    @Test
    public void testIsEmpty() {
        Assert.assertEquals((Object)true, (Object)StringTools.isEmpty((String)""));
        Assert.assertEquals((Object)true, (Object)StringTools.isEmpty(null));
        Assert.assertEquals((Object)false, (Object)StringTools.isEmpty((String)"a"));
    }

    @Test
    public void testFilterXML() {
        Assert.assertEquals((Object)"test", (Object)StringTools.filterXML((String)"test"));
        Assert.assertEquals((Object)"<<test>>", (Object)StringTools.filterXML((String)"<<test>>"));
        Assert.assertEquals((Object)"test", (Object)StringTools.filterXML((String)"<b>test</b>"));
        Assert.assertEquals((Object)"A sentence with a test", (Object)StringTools.filterXML((String)"A sentence with a <em>test</em>"));
    }

    @Test
    public void testAsString() {
        Assert.assertNull((Object)StringTools.asString(null));
        Assert.assertEquals((Object)"foo!", (Object)"foo!");
    }
}

