/*
 * Decompiled with CFR 0.152.
 */
package org.ioperm.morphology.el;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import org.ioperm.morphology.el.CharUtils;
import org.ioperm.morphology.el.Lemma;

public class GreekAnalyzer {
    private final Dictionary dictionary;

    public GreekAnalyzer() {
        try {
            InputStream data = this.getClass().getResourceAsStream("analysis.dict");
            InputStream meta = this.getClass().getResourceAsStream("analysis.info");
            this.dictionary = Dictionary.read((InputStream)data, (InputStream)meta);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<Lemma> getLemma(CharSequence word, boolean capitalized) {
        ArrayList<Lemma> l = new ArrayList<Lemma>();
        DictionaryLookup lookup = new DictionaryLookup(this.dictionary);
        List wl = lookup.lookup(word);
        for (WordData w : wl) {
            l.add(new Lemma(w));
        }
        if (capitalized) {
            StringBuilder builder = new StringBuilder(word);
            builder.setCharAt(0, CharUtils.toLower(builder.charAt(0), false));
            wl = lookup.lookup((CharSequence)builder);
            for (WordData w : wl) {
                Lemma newLemma = new Lemma(w);
                if (l.contains(newLemma)) continue;
                l.add(newLemma);
            }
        }
        return l;
    }
}

