/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;

public final class AnalyzedSentence {
    private final AnalyzedTokenReadings[] tokens;
    private final AnalyzedTokenReadings[] preDisambigTokens;
    private final AnalyzedTokenReadings[] nonBlankTokens;
    private final AnalyzedTokenReadings[] nonBlankPreDisambigTokens;
    private final int[] whPositions;
    private final Map<String, List<Integer>> tokenOffsets;
    private final Map<String, List<Integer>> lemmaOffsets;
    private volatile String text;

    public AnalyzedSentence(AnalyzedTokenReadings[] tokens) {
        this(tokens, tokens);
    }

    public AnalyzedSentence(AnalyzedTokenReadings[] tokens, AnalyzedTokenReadings[] preDisambigTokens) {
        this.tokens = tokens;
        this.preDisambigTokens = preDisambigTokens;
        int whCounter = 0;
        int nonWhCounter = 0;
        int[] mapping = new int[tokens.length + 1];
        this.whPositions = mapping;
        this.nonBlankTokens = this.getNonBlankReadings(tokens, whCounter, nonWhCounter, mapping).toArray(new AnalyzedTokenReadings[0]);
        this.nonBlankPreDisambigTokens = this.getNonBlankReadings(preDisambigTokens, whCounter, nonWhCounter, mapping).toArray(new AnalyzedTokenReadings[0]);
        this.tokenOffsets = AnalyzedSentence.indexTokens(this.nonBlankTokens);
        this.lemmaOffsets = AnalyzedSentence.indexLemmas(this.nonBlankTokens);
    }

    @NotNull
    private List<AnalyzedTokenReadings> getNonBlankReadings(AnalyzedTokenReadings[] tokens, int whCounter, int nonWhCounter, int[] mapping) {
        ArrayList<AnalyzedTokenReadings> l = new ArrayList<AnalyzedTokenReadings>();
        for (AnalyzedTokenReadings token : tokens) {
            if (!token.isWhitespace() || token.isSentenceStart() || token.isSentenceEnd() || token.isParagraphEnd()) {
                l.add(token);
                mapping[nonWhCounter] = whCounter;
                ++nonWhCounter;
            }
            ++whCounter;
        }
        return l;
    }

    private AnalyzedSentence(AnalyzedTokenReadings[] tokens, int[] mapping, AnalyzedTokenReadings[] nonBlankTokens, AnalyzedTokenReadings[] nonBlankPreDisambigTokens) {
        this.tokens = tokens;
        this.preDisambigTokens = tokens;
        this.whPositions = mapping;
        this.nonBlankTokens = nonBlankTokens;
        this.nonBlankPreDisambigTokens = nonBlankPreDisambigTokens;
        this.tokenOffsets = AnalyzedSentence.indexTokens(nonBlankTokens);
        this.lemmaOffsets = AnalyzedSentence.indexLemmas(nonBlankTokens);
    }

    private static Map<String, List<Integer>> indexTokens(AnalyzedTokenReadings[] tokens) {
        HashMap<String, List<Integer>> result = new HashMap<String, List<Integer>>(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            result.computeIfAbsent(tokens[i].getToken().toLowerCase(), __ -> new ArrayList(1)).add(i);
        }
        return AnalyzedSentence.makeUnmodifiable(result);
    }

    private static Map<String, List<Integer>> indexLemmas(AnalyzedTokenReadings[] tokens) {
        HashMap<String, List<Integer>> result = new HashMap<String, List<Integer>>(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            AnalyzedTokenReadings tr = tokens[i];
            int readingsLength = tr.getReadingsLength();
            for (int j = 0; j < readingsLength; ++j) {
                AnalyzedToken token = tr.getAnalyzedToken(j);
                String lemma = token.getLemma();
                String key = (lemma != null ? lemma : token.getToken()).toLowerCase();
                List list = result.computeIfAbsent(key, __ -> new ArrayList(1));
                if (!list.isEmpty() && (Integer)list.get(list.size() - 1) == i) continue;
                list.add(i);
            }
        }
        return AnalyzedSentence.makeUnmodifiable(result);
    }

    private static Map<String, List<Integer>> makeUnmodifiable(Map<String, List<Integer>> result) {
        for (Map.Entry<String, List<Integer>> entry : result.entrySet()) {
            entry.setValue(Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    public AnalyzedSentence copy(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] copyTokens = new AnalyzedTokenReadings[sentence.getTokens().length];
        for (int i = 0; i < copyTokens.length; ++i) {
            AnalyzedTokenReadings analyzedTokens = sentence.getTokens()[i];
            copyTokens[i] = new AnalyzedTokenReadings(analyzedTokens, analyzedTokens.getReadings(), "");
        }
        return new AnalyzedSentence(copyTokens, sentence.whPositions, sentence.getTokensWithoutWhitespace(), sentence.getPreDisambigTokensWithoutWhitespace());
    }

    public AnalyzedTokenReadings[] getTokens() {
        return this.tokens;
    }

    public AnalyzedTokenReadings[] getPreDisambigTokens() {
        return this.preDisambigTokens;
    }

    public AnalyzedTokenReadings[] getTokensWithoutWhitespace() {
        return (AnalyzedTokenReadings[])this.nonBlankTokens.clone();
    }

    public AnalyzedTokenReadings[] getPreDisambigTokensWithoutWhitespace() {
        return (AnalyzedTokenReadings[])this.nonBlankPreDisambigTokens.clone();
    }

    public int getOriginalPosition(int nonWhPosition) {
        return this.whPositions[nonWhPosition];
    }

    public String toString() {
        return this.toString(",");
    }

    public String toShortString(String readingDelimiter) {
        return this.toString(readingDelimiter, false);
    }

    public String getText() {
        String result = this.text;
        if (result == null) {
            this.text = result = this.calcText();
        }
        return result;
    }

    private String calcText() {
        StringBuilder sb = new StringBuilder();
        for (AnalyzedTokenReadings element : this.tokens) {
            sb.append(element.getToken());
        }
        return sb.toString();
    }

    public int getCorrectedTextLength() {
        int len = 0;
        for (int i = 0; i < this.tokens.length; ++i) {
            AnalyzedTokenReadings element = this.tokens[i];
            len += element.getCleanToken().length();
            if (i != this.tokens.length - 1) continue;
            len += element.getPosFix();
        }
        return len;
    }

    String toTextString() {
        return this.getText();
    }

    public String toString(String readingDelimiter) {
        return this.toString(readingDelimiter, true);
    }

    private String toString(String readingDelimiter, boolean includeChunks) {
        StringBuilder sb = new StringBuilder();
        for (AnalyzedTokenReadings element : this.tokens) {
            if (!element.isWhitespace()) {
                sb.append(element.getToken());
                sb.append('[');
            }
            Iterator<AnalyzedToken> iterator = element.iterator();
            while (iterator.hasNext()) {
                AnalyzedToken token = iterator.next();
                String posTag = token.getPOSTag();
                if (element.isSentenceStart()) {
                    sb.append("<S>");
                    continue;
                }
                if ("SENT_END".equals(posTag)) {
                    sb.append("</S>");
                    continue;
                }
                if ("PARA_END".equals(posTag)) {
                    sb.append("<P/>");
                    continue;
                }
                if (posTag == null && !includeChunks) {
                    sb.append(token.getToken());
                    continue;
                }
                if (element.isWhitespace()) continue;
                sb.append(token);
                if (!iterator.hasNext()) continue;
                sb.append(readingDelimiter);
            }
            if (!element.isWhitespace()) {
                if (includeChunks && element.getChunkTags().size() > 0) {
                    sb.append(',');
                    sb.append(StringUtils.join(element.getChunkTags(), (String)"|"));
                }
                if (element.isImmunized()) {
                    sb.append("{!}");
                }
                sb.append(']');
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    public String getAnnotations() {
        StringBuilder sb = new StringBuilder(40);
        sb.append("Disambiguator log: \n");
        for (AnalyzedTokenReadings element : this.tokens) {
            if (element.isWhitespace() || "".equals(element.getHistoricalAnnotations())) continue;
            sb.append(element.getHistoricalAnnotations());
            sb.append('\n');
        }
        return sb.toString();
    }

    public Set<String> getTokenSet() {
        return this.tokenOffsets.keySet();
    }

    public Set<String> getLemmaSet() {
        return this.lemmaOffsets.keySet();
    }

    @Nullable
    @ApiStatus.Internal
    public List<Integer> getTokenOffsets(String token) {
        return this.tokenOffsets.get(token);
    }

    @Nullable
    @ApiStatus.Internal
    public List<Integer> getLemmaOffsets(String token) {
        return this.lemmaOffsets.get(token);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyzedSentence other = (AnalyzedSentence)o;
        return Arrays.equals(this.nonBlankTokens, other.nonBlankTokens) && Arrays.equals(this.tokens, other.tokens) && Arrays.equals(this.whPositions, other.whPositions);
    }

    public int hashCode() {
        return Objects.hash(this.nonBlankTokens, this.tokens, this.whPositions);
    }
}

