/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.py;

import com.hankcs.hanlp.algorithm.ahocorasick.trie.Token;
import com.hankcs.hanlp.algorithm.ahocorasick.trie.Trie;
import com.hankcs.hanlp.dictionary.py.Integer2PinyinConverter;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.dictionary.py.String2PinyinConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TonePinyinString2PinyinConverter {
    static Map<String, Pinyin> mapKey;
    static Map<String, Pinyin> mapNumberKey;
    static Trie trie;

    public static boolean valid(String singlePinyin) {
        return mapNumberKey.containsKey(singlePinyin);
    }

    public static Pinyin convertFromToneNumber(String singlePinyin) {
        return mapNumberKey.get(singlePinyin);
    }

    public static List<Pinyin> convert(String[] pinyinArray) {
        ArrayList<Pinyin> pinyinList = new ArrayList<Pinyin>(pinyinArray.length);
        for (int i = 0; i < pinyinArray.length; ++i) {
            pinyinList.add(mapKey.get(pinyinArray[i]));
        }
        return pinyinList;
    }

    public static Pinyin convert(String singlePinyin) {
        return mapKey.get(singlePinyin);
    }

    public static List<Pinyin> convert(String tonePinyinText, boolean removeNull) {
        LinkedList<Pinyin> pinyinList = new LinkedList<Pinyin>();
        Collection<Token> tokenize = trie.tokenize(tonePinyinText);
        for (Token token : tokenize) {
            Pinyin pinyin = mapKey.get(token.getFragment());
            if (removeNull && pinyin == null) continue;
            pinyinList.add(pinyin);
        }
        return pinyinList;
    }

    public static boolean valid(String[] pinyinStringArray) {
        for (String p : pinyinStringArray) {
            if (TonePinyinString2PinyinConverter.valid(p)) continue;
            return false;
        }
        return true;
    }

    public static List<Pinyin> convertFromToneNumber(String[] pinyinArray) {
        ArrayList<Pinyin> pinyinList = new ArrayList<Pinyin>(pinyinArray.length);
        for (String py : pinyinArray) {
            pinyinList.add(TonePinyinString2PinyinConverter.convertFromToneNumber(py));
        }
        return pinyinList;
    }

    static {
        mapNumberKey = new TreeMap<String, Pinyin>();
        mapKey = new TreeMap<String, Pinyin>();
        for (Pinyin pinyin : Integer2PinyinConverter.pinyins) {
            mapNumberKey.put(pinyin.toString(), pinyin);
            String pinyinWithToneMark = pinyin.getPinyinWithToneMark();
            String pinyinWithoutTone = pinyin.getPinyinWithoutTone();
            Pinyin tone5 = String2PinyinConverter.convert2Tone5(pinyin);
            mapKey.put(pinyinWithToneMark, pinyin);
            mapKey.put(pinyinWithoutTone, tone5);
        }
        trie = new Trie().remainLongest();
        trie.addAllKeyword(mapKey.keySet());
    }
}

