/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algorithm.MaxHeap;
import com.hankcs.hanlp.corpus.occurrence.TermFrequency;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.summary.KeywordExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TermFrequencyCounter
extends KeywordExtractor
implements Collection<TermFrequency> {
    boolean filterStopWord;
    Map<String, TermFrequency> termFrequencyMap;

    public TermFrequencyCounter(Segment segment, boolean filterStopWord) {
        this.filterStopWord = filterStopWord;
        this.defaultSegment = segment;
        this.termFrequencyMap = new TreeMap<String, TermFrequency>();
    }

    public TermFrequencyCounter() {
        this(HanLP.newSegment(), true);
    }

    public void add(String document) {
        if (document == null || document.isEmpty()) {
            return;
        }
        List<Term> termList = this.defaultSegment.seg(document);
        this.add(termList);
    }

    public void add(List<Term> termList) {
        if (this.filterStopWord) {
            this.filter(termList);
        }
        for (Term term : termList) {
            String word = term.word;
            TermFrequency frequency = this.termFrequencyMap.get(word);
            if (frequency == null) {
                frequency = new TermFrequency(word);
                this.termFrequencyMap.put(word, frequency);
                continue;
            }
            frequency.increase();
        }
    }

    public Collection<TermFrequency> top(int N) {
        MaxHeap<TermFrequency> heap = new MaxHeap<TermFrequency>(N, new Comparator<TermFrequency>(){

            @Override
            public int compare(TermFrequency o1, TermFrequency o2) {
                return o1.compareTo(o2);
            }
        });
        heap.addAll(this.termFrequencyMap.values());
        return heap.toList();
    }

    public Collection<TermFrequency> all() {
        return this.termFrequencyMap.values();
    }

    @Override
    public int size() {
        return this.termFrequencyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.termFrequencyMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.termFrequencyMap.containsKey(o);
        }
        if (o instanceof TermFrequency) {
            return this.termFrequencyMap.containsValue(o);
        }
        return false;
    }

    @Override
    public Iterator<TermFrequency> iterator() {
        return this.termFrequencyMap.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.termFrequencyMap.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.termFrequencyMap.values().toArray(a);
    }

    @Override
    public boolean add(TermFrequency termFrequency) {
        TermFrequency tf = this.termFrequencyMap.get(termFrequency.getTerm());
        if (tf == null) {
            this.termFrequencyMap.put((String)termFrequency.getKey(), termFrequency);
            return true;
        }
        tf.increase(termFrequency.getFrequency());
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.termFrequencyMap.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends TermFrequency> c) {
        for (TermFrequency termFrequency : c) {
            this.add(termFrequency);
        }
        return !c.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            if (this.remove(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.termFrequencyMap.values().retainAll(c);
    }

    @Override
    public void clear() {
        this.termFrequencyMap.clear();
    }

    @Override
    public List<String> getKeywords(List<Term> termList, int size) {
        this.clear();
        this.add(termList);
        Collection<TermFrequency> topN = this.top(size);
        ArrayList<String> r = new ArrayList<String>(topN.size());
        for (TermFrequency termFrequency : topN) {
            r.add(termFrequency.getTerm());
        }
        return r;
    }

    public static List<String> getKeywordList(String document, int size) {
        return new TermFrequencyCounter().getKeywords(document, size);
    }

    public String toString() {
        int max = 100;
        return this.top(Math.min(100, this.size())).toString();
    }
}

