/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.languagetool.Language;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternToken;

public final class PatternTestTools {
    private static final Pattern TOKEN_SEPARATOR_PATTERN = Pattern.compile("[ \t.,:;\u2026!?(){}<>\u00ab\u00bb\"]");
    private static final Pattern TOKEN_SEPARATOR_PATTERN_NO_DOT = Pattern.compile("[ \t,:;\u2026!?(){}<>\u00ab\u00bb\"]");
    private static final Pattern PROBABLE_PATTERN = Pattern.compile("(\\\\[dDsSwW])|.*([^*]\\*|[.+?{}()|\\[\\]].*|\\\\d).*");
    private static final Pattern PROBABLE_PATTERN_PL_POS = Pattern.compile("(\\\\[dDsSwW])|.*([^*]\\*|[+?{}()|\\[\\]].*|\\\\d).*");
    private static final Pattern CHAR_SET_PATTERN = Pattern.compile("\\[^?([^\\]]+)\\]");
    private static final Pattern STRICT_CHAR_SET_PATTERN = Pattern.compile("(\\(\\?-i\\))?.*(?<!\\\\)\\[^?([^\\]]+)\\]");
    private static final Pattern UNBOUND_REPEAT = Pattern.compile(".*\\{\\d+,\\}.*");
    private static final Set<String> NO_REGEXP = new HashSet<String>(Arrays.asList("PRP:LOK+TMP+MOD:DAT+AKK", "AUX:ind+pres+3+p", "PRP:TMP+MOD+CAU:DAT", "PRP:LOK+TMP:DAT", "PRP:LOK+TMP+CAU:DAT+AKK", "PRP:MOD:GEN+DAT", "PRP:LOK+TMP+CAU:DAT"));

    private PatternTestTools() {
    }

    public static void failIfWhitespaceInToken(List<PatternToken> patternTokens, AbstractPatternRule rule, Language lang) {
        if (patternTokens != null) {
            for (PatternToken token : patternTokens) {
                if (token.getString() == null || !token.getString().matches(".*\\s.*")) continue;
                Assert.fail((String)("Whitespace found in token '" + token.getString() + "' of rule " + rule.getFullId() + " (language " + lang.getShortCodeWithCountryAndVariant() + "): Using whitespace in a token will not work, as text gets split at whitespace. Use a new <token> element instead."));
            }
        }
    }

    public static void warnIfRegexpSyntaxNotKosher(List<PatternToken> patternTokens, String ruleId, String ruleSubId, Language lang) {
        if (patternTokens == null) {
            return;
        }
        int i = 0;
        for (PatternToken pToken : patternTokens) {
            ++i;
            if (pToken.isReferenceElement()) continue;
            PatternTestTools.warnIfElementNotKosher(pToken.getString(), pToken.isRegularExpression(), pToken.isCaseSensitive(), pToken.getNegation(), pToken.isInflected(), false, lang, ruleId + "[" + ruleSubId + "]", i);
            PatternTestTools.warnIfElementNotKosher(pToken.getPOStag() == null ? "" : pToken.getPOStag(), pToken.isPOStagRegularExpression(), pToken.isCaseSensitive(), pToken.getPOSNegation(), false, true, lang, ruleId + "[" + ruleSubId + "] (POS tag)", i);
            ArrayList<PatternToken> exceptionPatternTokens = new ArrayList<PatternToken>();
            if (pToken.getExceptionList().isEmpty()) continue;
            for (PatternToken exception : pToken.getExceptionList()) {
                if (exception.hasNextException()) continue;
                if (!(pToken.getString().isEmpty() || exception.getString().isEmpty() || pToken.getNegation() || pToken.isInflected() || exception.getNegation() || exception.isInflected() || pToken.getSkipNext() != 0 || pToken.isCaseSensitive() != exception.isCaseSensitive())) {
                    if (exception.isRegularExpression()) {
                        if (pToken.isRegularExpression()) {
                            if (exception.getString().indexOf(124) >= 0) {
                                String[] alt;
                                for (String part : alt = exception.getString().split("\\|")) {
                                    if (exception.getString().indexOf(40) < 0) {
                                        if (!part.matches("[^.*?{}\\[\\]]+") || part.matches("(?i)" + pToken.getString())) continue;
                                        PatternTestTools.warn("The " + lang + " rule: " + ruleId + "[" + ruleSubId + "] has exception regexp [" + exception.getString() + "] which contains disjunction part [" + part + "] which seems useless since it does not match the regexp of token word [" + i + "] [" + pToken.getString() + "], or did you forget skip=\"...\" or scope=\"previous\"?");
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            PatternTestTools.warn("The " + lang + " rule: " + ruleId + "[" + ruleSubId + "] has exception regexp [" + exception.getString() + "] in token word [" + i + "] [" + pToken.getString() + "] which seems useless, or did you forget skip=\"...\" or scope=\"previous\"?");
                        }
                    } else if (pToken.isRegularExpression()) {
                        if (!exception.getString().matches((exception.isCaseSensitive() ? "" : "(?i)") + pToken.getString())) {
                            PatternTestTools.warn("The " + lang + " rule: " + ruleId + "[" + ruleSubId + "] has exception word [" + exception.getString() + "] which cannot match the regexp token [" + i + "] [" + pToken.getString() + "] so exception seems useless, or did you forget skip=\"...\" or scope=\"previous\"?");
                        }
                    } else {
                        PatternTestTools.warn("The " + lang + " rule: " + ruleId + "[" + ruleSubId + "] has exception word [" + exception.getString() + "] in token word [" + i + "] [" + pToken.getString() + "] which seems useless, or did you forget skip=\"...\" or scope=\"previous\"?");
                    }
                }
                if (!exception.getString().equals(".")) {
                    PatternTestTools.warnIfElementNotKosher(exception.getString(), exception.isRegularExpression(), exception.isCaseSensitive(), exception.getNegation(), exception.isInflected(), false, lang, ruleId + "[" + ruleSubId + "] (exception in token [" + i + "])", i);
                }
                PatternTestTools.warnIfElementNotKosher(exception.getPOStag() == null ? "" : exception.getPOStag(), exception.isPOStagRegularExpression(), exception.isCaseSensitive(), exception.getPOSNegation(), false, true, lang, ruleId + "[" + ruleSubId + "] (exception in POS tag of token [" + i + "])", i);
                for (PatternToken otherException : exceptionPatternTokens) {
                    if (!PatternTestTools.equalException(exception, otherException)) continue;
                    PatternTestTools.warn("The " + lang + " rule: " + ruleId + "[" + ruleSubId + "] in token [" + i + "] contains duplicate exceptions with string=[" + exception.getString() + "] POS tag=[" + exception.getPOStag() + "] negate=[" + exception.getNegation() + "] POS negate=[" + exception.getPOSNegation() + "]");
                    break;
                }
                exceptionPatternTokens.add(exception);
            }
        }
    }

    private static boolean equalException(PatternToken exception1, PatternToken exception2) {
        String posTag2;
        String string2;
        String string1 = exception1.getString() == null ? "" : exception1.getString();
        String string = string2 = exception2.getString() == null ? "" : exception2.getString();
        if (!exception1.isCaseSensitive() || !exception2.isCaseSensitive()) {
            string1 = string1.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (!(string1.isEmpty() || string2.isEmpty() || string1.equals(string2))) {
            return false;
        }
        String posTag1 = exception1.getPOStag() == null ? "" : exception1.getPOStag();
        String string3 = posTag2 = exception2.getPOStag() == null ? "" : exception2.getPOStag();
        if (!(posTag1.isEmpty() || posTag2.isEmpty() || posTag1.equals(posTag2))) {
            return false;
        }
        if (string1.isEmpty() != string2.isEmpty() && posTag1.isEmpty() != posTag2.isEmpty()) {
            return false;
        }
        return exception1.getNegation() == exception2.getNegation() && exception1.getPOSNegation() == exception2.getPOSNegation() && exception1.hasNextException() == exception2.hasNextException() && exception1.hasPreviousException() == exception2.hasPreviousException();
    }

    private static void warnIfElementNotKosher(String stringValue, boolean isRegularExpression, boolean isCaseSensitive, boolean isNegated, boolean isInflected, boolean isPos, Language lang, String ruleId, int tokenIndex) {
        Pattern regexPattern;
        if (!isPos && !isRegularExpression && stringValue.length() > 1) {
            Pattern tokenSeparatorPattern;
            Pattern pattern = tokenSeparatorPattern = lang.getShortCode().equals("uk") ? TOKEN_SEPARATOR_PATTERN_NO_DOT : TOKEN_SEPARATOR_PATTERN;
            if (tokenSeparatorPattern.matcher(stringValue).find()) {
                PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains \"" + stringValue + "\" that contains token separators, so can't possibly be matched.");
            }
        }
        Pattern pattern = regexPattern = isPos && lang.getShortCode().equals("pl") || !isPos && lang.getShortCode().equals("uk") ? PROBABLE_PATTERN_PL_POS : PROBABLE_PATTERN;
        if (!isRegularExpression && stringValue.length() > 1 && regexPattern.matcher(stringValue).find() && !NO_REGEXP.contains(stringValue)) {
            PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains \"" + stringValue + "\" that is not marked as regular expression but probably is one.");
        }
        if (isRegularExpression && stringValue.isEmpty()) {
            PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains an empty string \"" + stringValue + "\" that is marked as regular expression.");
        } else if (isRegularExpression && stringValue.length() > 1 && !regexPattern.matcher(stringValue).find()) {
            PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains \"" + stringValue + "\" that is marked as regular expression but probably is not one.");
        }
        if (isNegated && stringValue.isEmpty()) {
            PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], marked as negated but is empty so the negation is useless. Did you mix up negate=\"yes\" and negate_pos=\"yes\"?");
        }
        if (isInflected && stringValue.isEmpty()) {
            PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains \"" + stringValue + "\" that is marked as inflected but is empty, so the attribute is redundant.");
        }
        if (isRegularExpression && ".*".equals(stringValue)) {
            PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], marked as regular expression contains regular expression \".*\" which is useless: (use an empty string without regexp=\"yes\" such as <token/>)");
        }
        if (isRegularExpression) {
            Matcher strictMatcher;
            Matcher matcher;
            if (UNBOUND_REPEAT.matcher(stringValue).matches()) {
                PatternTestTools.warn(lang + ": Please limit repetition in regex, e.g. use '{2,30}' instead of '{2,}': " + stringValue + " (" + ruleId + ")");
            }
            if ((matcher = CHAR_SET_PATTERN.matcher(stringValue)).find() && (strictMatcher = STRICT_CHAR_SET_PATTERN.matcher(stringValue)).find()) {
                String s = strictMatcher.group(2).replaceAll("\\\\p\\{[^}]*\\}", "");
                if (s.indexOf(124) >= 0 && (s.indexOf(124) < 1 || s.charAt(s.indexOf(124) - 1) != '\\')) {
                    PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains | (pipe) in regexp bracket expression [" + strictMatcher.group(2) + "] which is unlikely to be correct.");
                }
                char[] sorted = s.toCharArray();
                Arrays.sort(sorted);
                for (int i = 1; i < sorted.length; ++i) {
                    char c = sorted[i];
                    if ("&\\-|".indexOf(c) >= 0 || sorted[i - 1] != c) continue;
                    PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains regexp part [" + strictMatcher.group(2) + "] which contains duplicated char [" + c + "].");
                    break;
                }
            }
            if (stringValue.contains("|")) {
                String[] groups;
                if (stringValue.contains("||") || stringValue.charAt(0) == '|' || stringValue.charAt(stringValue.length() - 1) == '|') {
                    PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains empty disjunction | within \"" + stringValue + "\".");
                }
                for (String group : groups = stringValue.split("[)(]")) {
                    String[] alt = group.split("\\|");
                    HashSet<String> partSet = new HashSet<String>();
                    HashSet<String> partSetNoCase = new HashSet<String>();
                    boolean hasSingleChar = false;
                    boolean hasSingleDot = false;
                    for (String part : alt) {
                        String partNoCase;
                        if (part.length() == 1) {
                            if (part.equals(".")) {
                                hasSingleDot = true;
                            } else {
                                hasSingleChar = true;
                            }
                        }
                        String string = partNoCase = isCaseSensitive ? part : part.toLowerCase();
                        if (partSetNoCase.contains(partNoCase)) {
                            if (partSet.contains(part)) {
                                PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains duplicated disjunction part (" + part + ") within \"" + stringValue + "\".");
                            } else {
                                PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains duplicated non case sensitive disjunction part (" + part + ") within \"" + stringValue + "\". Did you forget case_sensitive=\"yes\"?");
                            }
                        }
                        partSetNoCase.add(partNoCase);
                        partSet.add(part);
                    }
                    if (!hasSingleDot || !hasSingleChar) continue;
                    PatternTestTools.warn("The " + lang + " rule: " + ruleId + ", token [" + tokenIndex + "], contains a single dot (matching any char) so other single char disjunctions are useless within \"" + stringValue + "\". Did you forget forget a backslash before the dot?");
                }
            }
        }
    }

    private static void warn(String s) {
        System.err.println("*** WARNING: " + s);
    }
}

