/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;

public class AnalyzedSentenceTest {
    @Test
    public void testToString() {
        AnalyzedTokenReadings[] words = new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken("", "SENT_START", null)), new AnalyzedTokenReadings(new AnalyzedToken("word", "POS", "lemma")), new AnalyzedTokenReadings(new AnalyzedToken(".", "INTERP", null))};
        words[2].addReading(new AnalyzedToken(".", "SENT_END", null), "");
        AnalyzedSentence sentence = new AnalyzedSentence(words);
        Assert.assertEquals((Object)"<S> word[lemma/POS].[./INTERP,</S>]", (Object)sentence.toString());
    }

    @Test
    public void testCopy() {
        AnalyzedTokenReadings[] words = new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken("", "SENT_START", null)), new AnalyzedTokenReadings(new AnalyzedToken("word", "POS", "lemma")), new AnalyzedTokenReadings(new AnalyzedToken(".", "INTERP", null))};
        words[2].addReading(new AnalyzedToken(".", "SENT_END", null), "");
        AnalyzedSentence sentence = new AnalyzedSentence(words);
        AnalyzedSentence copySentence = sentence.copy(sentence);
        Assert.assertEquals((Object)sentence, (Object)copySentence);
        words[1].immunize(999);
        Assert.assertEquals((Object)"<S> word[lemma/POS{!}].[./INTERP,</S>]", (Object)sentence.toString());
        Assert.assertNotEquals((Object)sentence, (Object)copySentence);
    }
}

