/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.codepoints;

import de.bottlecaps.markup.blitz.Errors;
import de.bottlecaps.markup.blitz.codepoints.UnicodeCategory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Codepoint {
    public static final int EOI = Integer.MAX_VALUE;
    private static Pattern hexPattern = Pattern.compile("^0*(0|(?:[1-9A-Fa-f][0-9A-Fa-f]*))$");

    public static int of(String hex) {
        return Codepoint.of(hex, true);
    }

    static int of(String hex, boolean validate) {
        String stripped;
        Matcher matcher = hexPattern.matcher(hex);
        if (!matcher.find()) {
            Errors.S06.thro(hex);
        }
        if ((stripped = matcher.group(1)).length() > 6) {
            Errors.S07.thro(hex);
        }
        int codepoint = Integer.parseInt(hex, 16);
        if (validate) {
            if (codepoint > 0x10FFFF) {
                Errors.S07.thro(hex);
            }
            if (!UnicodeCategory.ALPHABET.containsCodepoint(codepoint) || UnicodeCategory.isSurrogate(codepoint)) {
                Errors.S08.thro(hex);
            }
        }
        return codepoint;
    }

    public static boolean isAscii(int codepoint) {
        return codepoint >= 32 && codepoint <= 126;
    }

    public static String toJava(int codepoint) {
        if (codepoint == 39) {
            return "'\\''";
        }
        if (codepoint == 92) {
            return "'\\\\'";
        }
        if (Codepoint.isAscii(codepoint)) {
            return "'" + (char)codepoint + "'";
        }
        return "0x" + Integer.toHexString(codepoint);
    }

    public static String toString(int codepoint) {
        if (codepoint == 39) {
            return "\"'\"";
        }
        if (Codepoint.isAscii(codepoint)) {
            return "'" + (char)codepoint + "'";
        }
        if (codepoint == Integer.MAX_VALUE) {
            return "end-of-input";
        }
        return "#" + Integer.toHexString(codepoint);
    }
}

