/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.FnSortBy;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ValueList;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Type;

public class ArraySortBy
extends FnSortBy {
    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        XQArray array = this.toArray(this.arg(0), qc);
        long as = array.structSize();
        if (as == 0L) {
            return array;
        }
        ValueList list = new ValueList(as);
        for (Value member : array.iterable()) {
            list.add(member);
        }
        Value[] values = (Value[])list.finish();
        Integer[] index = this.index(values, qc);
        if (ArraySortBy.sorted(index)) {
            return array;
        }
        ArrayBuilder ab = new ArrayBuilder(qc);
        Integer[] integerArray = index;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            ab.add(values[i2]);
        }
        return ab.array(this);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr array = this.arg(0);
        if (array == XQArray.empty()) {
            return array;
        }
        Type type = array.seqType().type;
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            this.exprType.assign(at);
        }
        return this;
    }
}

