/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.StringToken;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.expr.index.IndexStaticDb;
import org.basex.query.expr.index.ValueAccess;
import org.basex.query.func.db.DbAccessFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.util.hash.TokenSet;

public class DbText
extends DbAccessFn {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        Data data = this.toData(qc);
        return this.valueAccess(data, qc).iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Data data = this.toData(qc);
        return this.valueAccess(data, qc).value(qc);
    }

    @Override
    protected final Expr opt(CompileContext cc) throws QueryException {
        this.compileData(cc);
        this.arg(1, arg -> arg.simplifyFor(CompileContext.Simplify.DATA, cc).simplifyFor(CompileContext.Simplify.DISTINCT, cc));
        Data data = this.data();
        IndexType type = this.type();
        if (type != IndexType.TOKEN && data != null && this.arg(1) instanceof Value) {
            type.check(data, this.info);
            long size = 0L;
            for (byte[] token : this.tokens(cc.qc)) {
                int tl = token.length;
                if (tl == 0 || tl > data.meta.maxlen) {
                    return this;
                }
                size += (long)data.costs(new StringToken(type, token)).results();
            }
            this.exprType.assign(this.seqType(), size);
        }
        return this;
    }

    @Override
    public final boolean ddo() {
        return true;
    }

    IndexType type() {
        return IndexType.TEXT;
    }

    final ValueAccess valueAccess(Data data, QueryContext qc) throws QueryException {
        return new ValueAccess(this.info, this.tokens(qc), this.type(), null, (IndexDb)new IndexStaticDb(data, this.info));
    }

    private TokenSet tokens(QueryContext qc) throws QueryException {
        Item item;
        TokenSet set = new TokenSet();
        Iter iter = this.arg(1).iter(qc);
        while ((item = qc.next(iter)) != null) {
            set.put(this.toToken(item));
        }
        return set;
    }
}

