/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public final class FnCodepointsToString
extends StandardFunc {
    private boolean singleInt;

    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Expr values = this.arg(0);
        if (this.singleInt) {
            return Str.get(FnCodepointsToString.toCodepoint(values.item(qc, this.info).itr(this.info), this.info));
        }
        Iter iter = values.atomIter(qc, this.info);
        long size = iter.size();
        if (size == 1L) {
            return Str.get(FnCodepointsToString.toCodepoint(this.toLong(iter.next()), this.info));
        }
        TokenBuilder tb = new TokenBuilder(Seq.initialCapacity(size));
        while ((item = qc.next(iter)) != null) {
            tb.add(FnCodepointsToString.toCodepoint(this.toLong(item), this.info));
        }
        return Str.get(tb.finish());
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        if (!this.singleInt) {
            Item item = this.arg(0).atomIter(qc, this.info).next();
            if (item == null) {
                return false;
            }
            this.toLong(item);
        }
        return true;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr values = this.arg(0);
        if (Function.STRING_TO_CODEPOINTS.is(values)) {
            return cc.function(Function.STRING, this.info, values.args());
        }
        this.singleInt = values.seqType().instanceOf(SeqType.INTEGER_O);
        return this;
    }

    @Override
    protected boolean values(boolean limit, CompileContext cc) {
        return super.values(true, cc);
    }

    private static int toCodepoint(long value, InputInfo info) throws QueryException {
        int cp;
        if (value >= 0L && value <= Integer.MAX_VALUE && XMLToken.valid(cp = (int)value)) {
            return cp;
        }
        throw QueryError.INVCODE_X.get(info, "&#x" + Long.toHexString(value) + ";");
    }
}

