/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.basex.local;

import com.xqj2.XQInsertOptions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQQueryException;
import net.xqj.basex.BaseXXQInsertOptions;
import net.xqj.basex.Constants;
import net.xqj.basex.local.BasicQueryImpl;
import net.xqj.basic.BasicConnection;
import net.xqj.basic.BasicItem;
import net.xqj.basic.BasicQuery;
import net.xqj.basic.BasicResultSequence;
import net.xqj.core.TextContainer;
import net.xqj.core.XQToolkit;
import net.xqj.core.io.UTF8Reader;
import net.xqj.core.util.Logger;
import org.basex.api.client.LocalSession;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.BinaryPut;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Put;
import org.basex.core.cmd.Set;
import org.basex.core.parse.CommandParser;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerMode;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.B64Lazy;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.StrLazy;
import org.basex.server.LoginException;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Option;

public class BasicConnectionImpl
implements BasicConnection,
BasicResultSequence,
BasicItem {
    private static final Context mainContext = BasicConnectionImpl.initMainContext();
    private Iter iter;
    private Item item;
    private QueryProcessor queryProcessor;
    private boolean readOnly = false;
    private String user;
    private String password;
    private String databaseName;
    private BooleanOption defaultDb;
    private Context ctx;
    private Logger logger;
    private ArrayOutput localArrayOutput = new ArrayOutput();
    private Serializer ser = null;
    private TextContainer value = new TextContainer();
    private UTF8_2_UTF16 utf8_2_utf16 = new UTF8_2_UTF16();
    private InputStream2Base64 currentBase64Input = null;

    private static final Context initMainContext() {
        return new Context();
    }

    @Override
    public void connect() throws XQException {
        this.authenticate();
        this.setContextDatabase();
    }

    private void authenticate() throws XQException {
        if (this.user == null || this.user.trim().length() == 0) {
            this.ctx = mainContext;
        } else {
            try {
                this.ctx = new LocalSession(this.ctx, this.user, this.password).context();
            }
            catch (LoginException ex) {
                throw BasicConnectionImpl.XQException("Bad user credentials", "XQJNC001", null);
            }
        }
    }

    private void setContextDatabase() throws XQException {
        if (this.databaseName != null) {
            Open openCommand = new Open(this.databaseName);
            if (this.defaultDb == null) {
                this.setDefaultDb(Constants.DEFAULT_DEFAULTDB);
            }
            Set defaultDbOption = new Set((Option)this.defaultDb, (Object)this.defaultDb.value());
            try {
                openCommand.execute(this.ctx);
                defaultDbOption.execute(this.ctx);
            }
            catch (BaseXException e) {
                throw BasicConnectionImpl.XQException(e.getMessage(), "XQJBX009", e);
            }
        }
    }

    private void freeQueryProcessor() {
        if (this.queryProcessor != null) {
            this.queryProcessor.close();
            this.queryProcessor.unregister(this.ctx);
            this.queryProcessor = null;
            this.item = null;
            this.iter = null;
        }
    }

    @Override
    public BasicResultSequence executeQuery(BasicQuery query) throws XQException {
        this.freeQueryProcessor();
        this.queryProcessor = ((BasicQueryImpl)query).createQueryProcessor();
        try {
            this.queryProcessor.parse();
        }
        catch (QueryException e) {
            throw BasicConnectionImpl.XQQueryException(e.getMessage(), "XQJBX016", e);
        }
        this.queryProcessor.register(this.ctx);
        try {
            this.queryProcessor.compile();
            if (this.readOnly && this.queryProcessor.updating) {
                this.freeQueryProcessor();
                throw BasicConnectionImpl.XQException("Can not run updating XQuery statement while in read-only mode", "XQJBX004", null);
            }
            this.iter = this.queryProcessor.iter();
            return this;
        }
        catch (QueryException e) {
            this.freeQueryProcessor();
            throw BasicConnectionImpl.XQQueryException(e.getMessage(), "XQJBX003", e);
        }
    }

    @Override
    public BasicQuery createQuery() throws XQException {
        return new BasicQueryImpl(this.ctx);
    }

    @Override
    public void executeCommand(BasicQuery query) throws XQException {
        this.freeQueryProcessor();
        try {
            Command command = CommandParser.get((String)query.toString(), (Context)this.ctx).parseSingle();
            if (this.readOnly && command.updating(this.ctx)) {
                throw BasicConnectionImpl.XQException("can not execute updating commands while in read-only mode", "XQJBX012", null);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            command.execute(this.ctx, (OutputStream)bos);
            this.xqjLog(query.toString() + "\n" + new String(bos.toByteArray(), Constants.UTF8));
        }
        catch (QueryException e) {
            throw BasicConnectionImpl.XQException(e.getMessage(), "XQJBX006", e);
        }
        catch (BaseXException e) {
            throw BasicConnectionImpl.XQException(e.getMessage(), "XQJBX007", e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws XQException {
        this.readOnly = readOnly;
    }

    public void setDefaultDb(boolean defaultDb) throws XQException {
        this.defaultDb = new BooleanOption("DEFAULTDB", defaultDb);
    }

    @Override
    public void close() throws XQException {
        this.freeQueryProcessor();
        this.ctx = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void hint(String name, String value) throws XQException {
        if ("user".equals(name)) {
            this.user = value;
        } else if ("password".equals(name) && value != null) {
            this.password = value;
        } else if ("databaseName".equals(name)) {
            this.databaseName = value;
        } else if ("readOnly".equals(name)) {
            this.setReadOnly(BasicConnectionImpl.parseBoolean(value));
        } else if ("defaultDb".equals(name)) {
            this.setDefaultDb(BasicConnectionImpl.parseBoolean(value));
        }
    }

    @Override
    public void insert(String uri, XQItem item, XQInsertOptions options) throws XQException {
        Add createCommand;
        int insertStrategy;
        if (this.readOnly) {
            throw BasicConnectionImpl.XQException("Can not insert data whist in read-only mode.", "XQJBX011", null);
        }
        this.freeQueryProcessor();
        if (options == null) {
            insertStrategy = this.isXQItemTypeABinary(item) ? 3 : 1;
        } else if (options instanceof BaseXXQInsertOptions) {
            insertStrategy = ((BaseXXQInsertOptions)options).getInsertStrategy();
        } else {
            throw new IllegalArgumentException("XQInsertOptions argument should be a subclass of BaseXXQInsertOptions.");
        }
        if (insertStrategy == 2) {
            createCommand = new Add(uri);
        } else if (insertStrategy == 1) {
            createCommand = new Put(uri);
        } else if (insertStrategy == 3) {
            createCommand = new BinaryPut(uri);
        } else {
            throw BasicConnectionImpl.XQException("invalid insert strategy", "XQJBX010", null);
        }
        createCommand.setInput(this.getInputStreamFromItem(item));
        try {
            createCommand.execute(this.ctx);
        }
        catch (BaseXException e) {
            throw BasicConnectionImpl.XQException(e.getMessage(), "XQJBX008", e);
        }
    }

    @Override
    public void commit() throws XQException {
    }

    @Override
    public void rollback() throws XQException {
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws XQException {
    }

    @Override
    public boolean nextItem() throws XQException {
        if (this.queryProcessor.updating) {
            return false;
        }
        try {
            this.item = this.iter.next();
            return this.item != null;
        }
        catch (QueryException e) {
            throw BasicConnectionImpl.XQQueryException(e.getMessage(), "XQJBX002", e);
        }
    }

    @Override
    public BasicItem getItem() throws XQException {
        return this;
    }

    private final int getBaseXType() {
        return this.item.typeId().asByte();
    }

    @Override
    public int getItemKind() throws XQException {
        int bxType = this.getBaseXType();
        return bxType < 32 ? Constants.BASEX_2_XQJITEMKIND[bxType] : 1;
    }

    @Override
    public int getItemType() throws XQException {
        int bxType = this.getBaseXType();
        return bxType >= 32 || bxType <= 15 && bxType >= 10 ? Constants.BASEX_2_XQJITEMTYPE[bxType] : 1;
    }

    @Override
    public boolean hasURL() throws XQException {
        int bxType = this.getBaseXType();
        return bxType == 12 || bxType == 13 || bxType == 14 || bxType == 82;
    }

    @Override
    public String getURL() throws XQException {
        if (!this.hasURL()) {
            return "";
        }
        byte[] xdmInfo = this.item.xdmInfo();
        return new String(xdmInfo, 1, xdmInfo.length - 2, Constants.UTF8);
    }

    private InputStream2Base64 InputStream2Base64(InputStream in) {
        if (this.currentBase64Input == null) {
            this.currentBase64Input = new InputStream2Base64(in);
            return this.currentBase64Input;
        }
        return this.currentBase64Input.reset(in);
    }

    @Override
    public InputStream getInputStream() throws XQException {
        int bxType = this.getBaseXType();
        try {
            if (bxType == 38) {
                return new BufferedInputStream((InputStream)this.item.input(null));
            }
            if (bxType == 79) {
                return new BufferedInputStream(this.InputStream2Base64((InputStream)this.item.input(null)));
            }
            this.xqjLog(true, "Internally streaming BaseX type " + bxType + ", despite it not actually being a Stream-able type.\nThis means there is potentially a serious performance problem.");
            return XQToolkit.getUTF8InputStream(this.getCharBuffer().toString().toCharArray());
        }
        catch (QueryException e) {
            throw BasicConnectionImpl.XQException("Problem reading from stream.", "XQJBX014", e);
        }
    }

    @Override
    public Reader getReader() throws XQException {
        UTF8Reader reader = new UTF8Reader();
        reader.setInput(this.getInputStream());
        return reader;
    }

    private void initSerializer() throws XQException {
        if (this.ser != null) {
            this.localArrayOutput.reset();
            this.ser.reset();
            this.value.reset();
            return;
        }
        try {
            this.ser = Serializer.get((OutputStream)this.localArrayOutput, (SerializerOptions)SerializerMode.API.get());
        }
        catch (IOException e) {
            throw BasicConnectionImpl.XQException("Error serializing item value", "XQJBX001", e);
        }
    }

    private void serializeItem() throws XQException {
        try {
            this.initSerializer();
            this.ser.serialize(this.item);
            this.utf8_2_utf16.ArrayOutputToTextContainer();
        }
        catch (IOException e) {
            throw BasicConnectionImpl.XQException("Error serializing item value", "XQJBX001", e);
        }
    }

    @Override
    public CharBuffer getCharBuffer() throws XQException {
        this.serializeItem();
        return this.utf8_2_utf16.getCharBuffer();
    }

    @Override
    public boolean isStreaming() {
        int bxType = this.getBaseXType();
        return bxType == 38 && this.item instanceof StrLazy || bxType == 79 && this.item instanceof B64Lazy;
    }

    @Override
    public char[] toCharArray() throws XQException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeItem(Writer out) throws XQException {
        throw new UnsupportedOperationException();
    }

    private static final XQException XQException(String message, String code, Throwable e) {
        return new XQException(message, code);
    }

    private static final XQException XQQueryException(String message, String code, QueryException e) {
        return new XQQueryException(e.getMessage(), e.qname().toJava(), e.line(), e.column(), -1);
    }

    private void xqjLog(String msg) {
        this.xqjLog(false, msg);
    }

    private void xqjLog(boolean warning, String msg) {
        if (this.logger != null) {
            if (warning && this.logger.isWarnLoggable()) {
                this.logger.log(2, msg);
            } else if (!warning && this.logger.isInfoLoggable()) {
                this.logger.log(3, msg);
            }
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private InputStream getInputStreamFromItem(XQItem item) throws XQException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        item.writeItem((OutputStream)bos, null);
        return new ByteArrayInputStream(bos.toByteArray());
    }

    private boolean isXQItemTypeABinary(XQItem item) throws XQException {
        int atomicType = item.getItemType().getBaseType();
        return atomicType == 26 || atomicType == 9;
    }

    static final boolean parseBoolean(String value) {
        if ("yes".equals(value) || "true".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("no".equals(value) || "false".equals(value) || "0".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("'" + value + "' is not a boolean value");
    }

    private class UTF8_2_UTF16 {
        private int _start;
        private int _end;
        private int _code;
        private int _moreBytes;
        private byte[] _bytes;
        private CharBuffer charBuffer;

        private UTF8_2_UTF16() {
        }

        private void ArrayOutputToTextContainer() throws IOException {
            this._start = 0;
            this._moreBytes = 0;
            this._code = 0;
            this._bytes = BasicConnectionImpl.this.localArrayOutput.buffer();
            this._end = (int)BasicConnectionImpl.this.localArrayOutput.size();
            while (this._start != this._end) {
                byte b = this._bytes[this._start];
                if (b >= 0) {
                    BasicConnectionImpl.this.value.append((char)b);
                    ++this._start;
                    continue;
                }
                int code = this.readUTF8();
                if (code < 65536) {
                    BasicConnectionImpl.this.value.append((char)code);
                    continue;
                }
                if (code <= 0x10FFFF) {
                    BasicConnectionImpl.this.value.append((char)((code - 65536 >> 10) + 55296));
                    BasicConnectionImpl.this.value.append((char)((code - 65536 & 0x3FF) + 56320));
                    continue;
                }
                throw new CharConversionException("Cannot convert U+" + Integer.toHexString(code) + " to char (code greater than U+10FFFF)");
            }
        }

        private int readUTF8() throws IOException {
            if (this._start < this._end) {
                byte b;
                if ((b = this._bytes[this._start++]) >= 0 && this._moreBytes == 0) {
                    return b;
                }
                if (this._moreBytes != 0 && (b & 0xC0) == 128) {
                    this._code = this._code << 6 | b & 0x3F;
                    if (--this._moreBytes == 0) {
                        return this._code;
                    }
                    return this.readUTF8();
                }
                if (this._moreBytes == 0 && (b & 0xE0) == 192) {
                    this._code = b & 0x1F;
                    this._moreBytes = 1;
                    return this.readUTF8();
                }
                if (this._moreBytes == 0 && (b & 0xF0) == 224) {
                    this._code = b & 0xF;
                    this._moreBytes = 2;
                    return this.readUTF8();
                }
                if (this._moreBytes == 0 && (b & 0xF8) == 240) {
                    this._code = b & 7;
                    this._moreBytes = 3;
                    return this.readUTF8();
                }
                if (this._moreBytes == 0 && (b & 0xFC) == 248) {
                    this._code = b & 3;
                    this._moreBytes = 4;
                    return this.readUTF8();
                }
                if (this._moreBytes == 0 && (b & 0xFE) == 252) {
                    this._code = b & 1;
                    this._moreBytes = 5;
                    return this.readUTF8();
                }
                throw new CharConversionException("Invalid UTF-8 Encoding");
            }
            if (this._moreBytes == 0) {
                return -1;
            }
            throw new CharConversionException("Unexpected end of stream");
        }

        public CharBuffer getCharBuffer() throws XQException {
            if (this.charBuffer == null || BasicConnectionImpl.this.value.length() > this.charBuffer.capacity()) {
                this.charBuffer = CharBuffer.wrap(BasicConnectionImpl.this.value.getRawCharArray(), BasicConnectionImpl.this.value.offset(), BasicConnectionImpl.this.value.length());
            } else {
                this.charBuffer.clear();
                this.charBuffer.put(BasicConnectionImpl.this.value.getRawCharArray(), BasicConnectionImpl.this.value.offset(), BasicConnectionImpl.this.value.length());
                this.charBuffer.flip();
            }
            return this.charBuffer;
        }
    }

    private static class InputStream2Base64
    extends InputStream {
        private static byte[] map1;
        private InputStream in;
        private byte[] buffer = new byte[1024];
        private byte[] out = null;
        private int outPos = 0;
        private int outLength = 0;

        public InputStream2Base64(InputStream in) {
            this.in = in;
        }

        public InputStream2Base64 reset(InputStream in) {
            this.in = in;
            this.outPos = 0;
            this.outLength = 0;
            return this;
        }

        private int readImpl() throws IOException {
            int iLen = this.in.read(this.buffer);
            if (iLen == -1) {
                this.outLength = -1;
                return -1;
            }
            int oDataLen = (iLen * 4 + 2) / 3;
            int oLen = (iLen + 2) / 3 * 4;
            if (oLen > this.outLength) {
                this.out = new byte[oLen];
            }
            this.outPos = 0;
            this.outLength = oLen;
            int ip = 0;
            int op = 0;
            while (ip < iLen) {
                int i0 = this.buffer[ip++] & 0xFF;
                int i1 = ip < iLen ? this.buffer[ip++] & 0xFF : 0;
                int i2 = ip < iLen ? this.buffer[ip++] & 0xFF : 0;
                int o0 = i0 >>> 2;
                int o1 = (i0 & 3) << 4 | i1 >>> 4;
                int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
                int o3 = i2 & 0x3F;
                this.out[op++] = map1[o0];
                this.out[op++] = map1[o1];
                this.out[op] = op < oDataLen ? map1[o2] : 61;
                int n = ++op < oDataLen ? map1[o3] : 61;
                this.out[op] = n;
                ++op;
            }
            return iLen;
        }

        @Override
        public int read() throws IOException {
            if (this.outPos == this.outLength) {
                this.readImpl();
            }
            if (this.outLength == -1) {
                return -1;
            }
            return this.out[this.outPos++];
        }

        static {
            int c;
            map1 = new byte[64];
            int i = 0;
            for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
                InputStream2Base64.map1[i++] = (byte)c;
            }
            for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
                InputStream2Base64.map1[i++] = (byte)c;
            }
            for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
                InputStream2Base64.map1[i++] = (byte)c;
            }
            InputStream2Base64.map1[i++] = 43;
            InputStream2Base64.map1[i++] = 47;
        }
    }
}

