/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.xquery.XQException;
import net.xqj.core.Factory;
import net.xqj.core.Text2XQuerySyntax;
import net.xqj.core.XQDynamicExpression;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitem.XQItemBase;
import org.w3c.dom.Node;

public class NodeXQItem
extends XQItemBase
implements Cloneable {
    private char[] value;
    private int offset;
    private int length;
    private Node nodeValue = null;

    private NodeXQItem(char[] lexicalRepresentation) {
        this(lexicalRepresentation, 0, lexicalRepresentation.length);
    }

    private NodeXQItem(char[] lexicalRepresentation, int offset, int length) {
        this.value = lexicalRepresentation;
        this.offset = offset;
        this.length = length;
    }

    public static final NodeXQItem newInstance(char[] lexicalRepresentation) {
        return new NodeXQItem(lexicalRepresentation);
    }

    public static final NodeXQItem newInstance(char[] lexicalRepresentation, int offset, int length) {
        return new NodeXQItem(lexicalRepresentation, offset, length);
    }

    public void setTextValue(char[] buffer, int offset, int length) {
        this.nodeValue = null;
        this.value = buffer;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public Node getNode() throws XQException {
        if (this.nodeValue != null) {
            return this.nodeValue;
        }
        switch (this.getItemType().getItemKind()) {
            case 11: {
                this.nodeValue = Factory.newTextNode(this.createString());
                return this.nodeValue;
            }
            case 3: {
                this.nodeValue = Factory.newCommentNode(this.createString());
                return this.nodeValue;
            }
            case 10: {
                this.nodeValue = Factory.newProcessingInstructionNode(this.getItemType().getPIName(), this.createString());
                return this.nodeValue;
            }
            case 2: 
            case 13: {
                this.nodeValue = Factory.newAttrNode(this.getItemType().getNodeName(), this.createString());
                return this.nodeValue;
            }
        }
        throw new XQExceptionImpl("Can not serialize " + XQDynamicExpression.ITEMKIND_LOOKUP[this.getItemType().getItemKind()] + " to a Java org.w3c.dom.Node object.", "XQJNI001");
    }

    @Override
    public Object getObject() throws XQException {
        return this.getNode();
    }

    @Override
    public String getItemAsString(Properties properties) throws XQException {
        if (this.getItemType().getItemKind() == 2 || this.getItemType().getItemKind() == 13) {
            throw new XQExceptionImpl("The XQuery 1.0 / XSLT 2.0 Serialization spec states that attributes can not be serialized into text.", "XQJNI002");
        }
        StringWriter strWriter = new StringWriter();
        this.writeItem(strWriter, properties);
        return strWriter.toString();
    }

    @Override
    public void writeItem(OutputStream out, Properties properties) throws XQException {
        this.writeItem(Factory.newUTF8Writer(out), properties);
    }

    @Override
    public void writeItem(Writer writer, Properties properties) throws XQException {
        switch (this.getItemType().getItemKind()) {
            case 3: {
                Text2XQuerySyntax.writeComment(writer, this.value, this.offset, this.length);
                break;
            }
            case 2: 
            case 13: {
                if (XQToolkit.isToWriteXQuery(properties)) {
                    Text2XQuerySyntax.writeAttribute(writer, this.value, this.offset, this.length, this.getItemType());
                    break;
                }
                throw new XQExceptionImpl("The XQuery 1.0 / XSLT 2.0 Serialization spec states that attributes can not be serialized into text.", "XQJNI003");
            }
            case 10: {
                Text2XQuerySyntax.writeProcessingInstruction(writer, this.value, this.offset, this.length, this.getItemType());
                break;
            }
            case 11: {
                if (XQToolkit.isToWriteXQuery(properties)) {
                    Text2XQuerySyntax.writeText(writer, this.value, this.offset, this.length);
                    break;
                }
                try {
                    writer.write(this.value, this.offset, this.length);
                    writer.flush();
                    break;
                }
                catch (IOException e) {
                    throw new XQExceptionImpl("problem writing data.", "XQJNI004", e);
                }
            }
        }
    }

    private String createString() {
        return new String(this.value, this.offset, this.length);
    }

    @Override
    public Object clone() {
        NodeXQItem newItem = (NodeXQItem)super.clone();
        newItem.value = XQToolkit.copyOfRange(this.value, this.offset, this.offset + this.length);
        newItem.offset = 0;
        if (newItem.nodeValue != null) {
            newItem.nodeValue = this.nodeValue.cloneNode(true);
        }
        return newItem;
    }
}

