/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public final class RowLayout
implements LayoutManager {
    private final int gap;

    public RowLayout() {
        this(0);
    }

    public RowLayout(int gap) {
        this.gap = gap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container cont) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            int w = 0;
            int h = 0;
            for (Component comp : cont.getComponents()) {
                Dimension d = comp.getPreferredSize();
                w = Math.max(w, d.width);
                h += this.gap + d.height;
            }
            Insets in = cont.getInsets();
            return new Dimension(in.left + w + in.right, in.top + Math.max(h - this.gap, 0) + in.bottom);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container cont) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            int y = 0;
            Insets in = cont.getInsets();
            for (Component comp : cont.getComponents()) {
                Dimension d = comp.getPreferredSize();
                comp.setBounds(in.left, in.top + y, d.width, d.height);
                y += this.gap + d.height;
            }
        }
    }
}

