/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IntPos;
import org.basex.query.expr.Range;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class CmpIR
extends Single {
    public final long min;
    public final long max;
    private boolean single;

    private CmpIR(Expr expr, long min, long max, InputInfo info) {
        super(info, expr, Types.BOOLEAN_O);
        this.min = min;
        this.max = max;
    }

    static Expr get(CompileContext cc, InputInfo info, Expr expr, long min, long max) throws QueryException {
        return min > max ? Bln.FALSE : (min == Long.MIN_VALUE && max == Long.MAX_VALUE ? cc.function(Function.EXISTS, info, expr) : new CmpIR(expr, min, max, info).optimize(cc));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Expr get(CompileContext cc, CmpG cmp, boolean eq) throws QueryException {
        long mx;
        long mn;
        boolean cmpEq;
        Expr expr1 = cmp.exprs[0];
        Expr expr2 = cmp.exprs[1];
        if (cmp.has(Flag.NDT)) {
            return cmp;
        }
        Type type1 = expr1.seqType().type;
        boolean bl = cmpEq = cmp.op == CmpG.OpG.EQ;
        if (!(type1.instanceOf(AtomType.INTEGER) || cmpEq && type1.isUntyped())) {
            return cmp;
        }
        if (expr2 instanceof RangeSeq) {
            RangeSeq rs = (RangeSeq)expr2;
            mn = rs.min();
            mx = rs.max();
        } else {
            if (!(expr2 instanceof Itr)) return cmp;
            Itr itr = (Itr)expr2;
            if (!eq && cmpEq) return cmp;
            mx = mn = itr.itr();
        }
        switch (cmp.op) {
            case GE: {
                mx = Long.MAX_VALUE;
                return CmpIR.get(cc, cmp.info, expr1, mn, mx);
            }
            case GT: {
                ++mn;
                mx = Long.MAX_VALUE;
                return CmpIR.get(cc, cmp.info, expr1, mn, mx);
            }
            case LE: {
                mn = Long.MIN_VALUE;
                return CmpIR.get(cc, cmp.info, expr1, mn, mx);
            }
            case LT: {
                mn = Long.MIN_VALUE;
                --mx;
                return CmpIR.get(cc, cmp.info, expr1, mn, mx);
            }
            case EQ: {
                return CmpIR.get(cc, cmp.info, expr1, mn, mx);
            }
            default: {
                return cmp;
            }
        }
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        SeqType st = this.expr.seqType();
        boolean bl = this.single = st.zeroOrOne() && !st.mayBeArray();
        if (Function.POSITION.is(this.expr)) {
            return cc.replaceWith(this, IntPos.get(this.min, this.max, this.info));
        }
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        Item item;
        if (this.single) {
            Item item2 = this.expr.item(qc, this.info);
            return !item2.isEmpty() && this.inRange(item2);
        }
        if (this.expr instanceof Range || this.expr instanceof RangeSeq) {
            Value value = this.expr.value(qc);
            long size = value.size();
            if (size == 0L) {
                return false;
            }
            if (size == 1L) {
                return this.inRange((Item)value);
            }
            RangeSeq rs = (RangeSeq)value;
            return rs.max() >= this.min && rs.min() <= this.max;
        }
        Iter iter = this.expr.atomIter(qc, this.info);
        while ((item = qc.next(iter)) != null) {
            if (!this.inRange(item)) continue;
            return true;
        }
        return false;
    }

    private boolean inRange(Item item) throws QueryException {
        double value = item.dbl(this.info);
        return value >= (double)this.min && value <= (double)this.max && value == (double)((long)value);
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) throws QueryException {
        Long newMin = null;
        Long newMax = null;
        if (ex instanceof CmpIR) {
            CmpIR cmp = (CmpIR)ex;
            newMin = cmp.min;
            newMax = cmp.max;
        } else if (ex instanceof CmpG) {
            Expr expr;
            CmpG cmp = (CmpG)ex;
            if (cmp.op == CmpG.OpG.EQ && (expr = ex.arg(1)) instanceof Itr) {
                Itr itr = (Itr)expr;
                newMax = newMin = Long.valueOf(itr.itr());
            }
        }
        if (newMin == null || !this.expr.equals(ex.arg(0)) || or && (this.max < newMin || this.min > newMax)) {
            return null;
        }
        newMin = or ? Math.min(this.min, newMin) : Math.max(this.min, newMin);
        newMax = or ? Math.max(this.max, newMax) : Math.min(this.max, newMax);
        return CmpIR.get(cc, this.info, this.expr, newMin, newMax);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        CmpIR cmp = new CmpIR(this.expr.copy(cc, vm), this.min, this.max, this.info);
        cmp.single = this.single;
        return this.copyType(cmp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof CmpIR)) return false;
        CmpIR cmp = (CmpIR)obj;
        if (this.min != cmp.min) return false;
        if (this.max != cmp.max) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public String description() {
        return "integer range comparison";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "min", this.min, "max", this.max, "single", this.single), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.expr);
        if (this.min == this.max) {
            qs.token("=").token(this.min);
        } else if (this.min != Long.MIN_VALUE && this.max != Long.MAX_VALUE) {
            qs.token("=").token(this.min).token("to").token(this.max);
        } else if (this.min != Long.MIN_VALUE) {
            qs.token(">=").token(this.min);
        } else {
            qs.token("<=").token(this.max);
        }
    }
}

