/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpPos;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.Simple;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class IntPos
extends Simple
implements CmpPos {
    final long min;
    final long max;

    private IntPos(long min, long max, InputInfo info) {
        super(info, Types.BOOLEAN_O);
        this.min = min;
        this.max = max;
    }

    public static Expr get(long min, long max, InputInfo info) {
        return min > max || max < 1L ? Bln.FALSE : (min <= 1L && max == Long.MAX_VALUE ? Bln.TRUE : new IntPos(Math.max(1L, min), Math.max(1L, max), info));
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        this.ctxValue(qc);
        long p = qc.focus.pos;
        return p >= this.min && p <= this.max;
    }

    @Override
    public Value positions(QueryContext qc) {
        return RangeSeq.get(this.min, this.max - this.min + 1L, true);
    }

    @Override
    public boolean exact() {
        return this.min == this.max;
    }

    @Override
    public Expr inline(InlineContext ic) {
        return null;
    }

    @Override
    public IntPos copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new IntPos(this.min, this.max, this.info));
    }

    @Override
    public Expr invert(CompileContext cc) throws QueryException {
        if (this.exact()) {
            Expr pos = cc.function(Function.POSITION, this.info, new Expr[0]);
            return new CmpG(this.info, pos, (Expr)Itr.get(this.min), CmpG.OpG.NE).optimize(cc);
        }
        return this.min == 1L ? IntPos.get(this.max + 1L, Long.MAX_VALUE, this.info) : (this.max == Long.MAX_VALUE ? IntPos.get(1L, this.min - 1L, this.info) : null);
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) {
        if (ex instanceof IntPos) {
            IntPos pos2;
            IntPos pos = (IntPos)ex;
            boolean smaller = this.min < pos.min;
            IntPos pos1 = smaller ? this : pos;
            IntPos intPos = pos2 = smaller ? pos : this;
            if (!or) {
                return IntPos.get(pos2.min, Math.min(pos1.max, pos2.max), this.info);
            }
            if (pos1.max + 1L >= pos2.min) {
                return IntPos.get(pos1.min, Math.max(pos1.max, pos2.max), this.info);
            }
        }
        return null;
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.POS.oneOf(flags) || Flag.CTX.oneOf(flags) || super.has(flags);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof IntPos)) return false;
        IntPos pos = (IntPos)obj;
        if (this.min != pos.min) return false;
        if (this.max != pos.max) return false;
        return true;
    }

    @Override
    public String description() {
        return "positional access";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "min", this.min, "max", this.max == Long.MAX_VALUE ? "inf" : Long.valueOf(this.max)), new ExprInfo[0]);
    }

    @Override
    public void toString(QueryString qs) {
        qs.function(Function.POSITION, new Object[0]);
        if (this.exact()) {
            qs.token("=").token(this.min);
        } else if (this.max == Long.MAX_VALUE) {
            qs.token(">=").token(this.min);
        } else if (this.min == 1L) {
            qs.token("<=").token(this.max);
        } else {
            qs.token("=").token(this.min).token("to").token(this.max);
        }
    }
}

