/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.Value;
import org.basex.query.value.item.Itr;
import org.basex.util.Util;

public final class FileSize
extends FileFn {
    @Override
    public Value eval(QueryContext qc) throws IOException, QueryException {
        BasicFileAttributes attrs;
        Path path = this.toPath(this.arg(0), qc);
        boolean recursive = this.toBooleanOrFalse(this.arg(1), qc);
        long size = recursive ? FileSize.size(path, qc) : ((attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0])).isDirectory() ? 0L : attrs.size());
        return Itr.get(size);
    }

    private static long size(Path path, QueryContext qc) throws IOException {
        BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        long s = 0L;
        if (attrs.isDirectory()) {
            try (DirectoryStream<Path> children = Files.newDirectoryStream(path);){
                for (Path child : children) {
                    qc.checkStop();
                    s += FileSize.size(child, qc);
                }
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        } else if (attrs.isRegularFile()) {
            s = attrs.size();
        }
        return s;
    }
}

