/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.map.XQHashMap;
import org.basex.query.value.map.XQItemValueMap;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.util.hash.IntObjectMap;

public final class XQIntValueMap
extends XQHashMap {
    private static final MapType TYPE = MapType.get(AtomType.INTEGER, Types.ITEM_ZM);
    private final IntObjectMap<Value> map;

    XQIntValueMap(int capacity) {
        super(TYPE);
        this.map = new IntObjectMap(capacity);
    }

    @Override
    public long structSize() {
        return this.map.size();
    }

    @Override
    public Value getOrNull(Item key) {
        int i;
        int v;
        ANum num;
        double d;
        if (key instanceof ANum && (d = (num = (ANum)key).dbl()) == (double)(v = (int)d) && (i = this.map.index(v)) != 0) {
            return this.valueAt(i - 1);
        }
        return null;
    }

    @Override
    public Value keys() {
        return IntSeq.get(this.map.keys());
    }

    @Override
    public Item keyAt(int index) {
        return Itr.get(this.map.key(index + 1));
    }

    @Override
    public Value valueAt(int index) {
        return this.map.value(index + 1);
    }

    @Override
    void valueAt(int index, Value value) {
        this.map.value(index + 1, value);
    }

    @Override
    XQHashMap build(Item key, Value value) throws QueryException {
        int k = XQIntValueMap.toInt(key);
        if (k != Integer.MIN_VALUE) {
            this.map.put(k, value);
            return this;
        }
        return new XQItemValueMap(this.map.capacity() - 2).build(this).build(key, value);
    }

    @Override
    public Item shrink(QueryContext qc) throws QueryException {
        this.shrinkValues(qc);
        this.refineType();
        SeqType vt = ((MapType)this.type).valueType();
        return vt.one() && vt.type.oneOf(AtomType.INTEGER, AtomType.STRING) ? this.rebuild(qc) : this;
    }
}

