/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.ParseExpr;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.Types;
import org.basex.query.var.StaticVar;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

final class StaticVarRef
extends ParseExpr {
    private final QNm name;
    private StaticVar var;
    final boolean hasImport;

    StaticVarRef(InputInfo info, QNm name, boolean hasImport) {
        super(info, Types.ITEM_ZM);
        this.name = name;
        this.hasImport = hasImport;
    }

    @Override
    public void checkUp() {
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.var.compile(cc);
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        Value value = this.var.value;
        if (value != null) {
            cc.info("inline %", this);
            return value;
        }
        this.exprType.assign(this.var.seqType());
        return this;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.var.value(qc);
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.var != null && this.var.has(flags);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.staticVar(this.var);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        StaticVarRef ref = new StaticVarRef(this.info, this.name, this.hasImport);
        ref.var = this.var;
        return this.copyType(ref);
    }

    @Override
    public int exprSize() {
        return 0;
    }

    @Override
    public boolean inlineable(InlineContext v) {
        return true;
    }

    @Override
    public VarUsage count(Var v) {
        return VarUsage.NEVER;
    }

    @Override
    public Expr inline(InlineContext ic) {
        return null;
    }

    void init(StaticVar vr) throws QueryException {
        if (vr.anns.contains(Annotation.PRIVATE) && !this.sc().baseURI().eq(vr.sc.baseURI())) {
            throw QueryError.VARPRIVATE_X.get(this.info, this);
        }
        this.var = vr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof StaticVarRef)) return false;
        StaticVarRef svr = (StaticVarRef)obj;
        if (!this.name.eq(svr.name)) return false;
        if (this.var != svr.var) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "var", this.name), new ExprInfo[0]);
    }

    @Override
    public void toString(QueryString qs) {
        qs.concat("$", this.name.string());
    }
}

