/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.io.InputStream;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.io.in.InputException;
import org.basex.io.in.TextDecoder;
import org.basex.util.Array;
import org.basex.util.Strings;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public class TextInput
extends BufferInput {
    private TextDecoder decoder;
    private boolean validate;

    public TextInput(InputStream is) throws IOException {
        this(is, null);
    }

    public TextInput(InputStream is, String encoding) throws IOException {
        super(is);
        this.guess(encoding);
    }

    public TextInput(IO io) throws IOException {
        this(io, null);
    }

    public TextInput(IO io, String encoding) throws IOException {
        super(io);
        this.guess(encoding);
    }

    private void guess(String encoding) throws IOException {
        try {
            int a = this.readByte();
            int b = this.readByte();
            int c = this.readByte();
            int d = this.readByte();
            String enc = Strings.normEncoding(encoding, false);
            int skip = 0;
            if (Strings.eq(enc, "UTF-8", null) && a == 239 && b == 187 && c == 191) {
                enc = "UTF-8";
                skip = 3;
            } else if (Strings.eq(enc, "UTF-16", "UTF-16LE", null) && a == 255 && b == 254) {
                enc = "UTF-16LE";
                skip = 2;
            } else if (Strings.eq(enc, "UTF-16", "UTF-16BE", null) && a == 254 && b == 255) {
                enc = "UTF-16BE";
                skip = 2;
            } else if (Strings.eq(enc, "UTF-16", null) && a == 60 && b == 0 && c == 63 && d == 0) {
                enc = "UTF-16LE";
            } else if (Strings.eq(enc, "UTF-16", null) && a == 0 && b == 60 && c == 0 && d == 63) {
                enc = "UTF-16BE";
            } else if (Strings.eq(enc, "UTF-16")) {
                enc = "UTF-16BE";
            } else if (enc == null) {
                enc = "UTF-8";
            }
            this.reset();
            for (int s = 0; s < skip; ++s) {
                this.readByte();
            }
            this.decoder = TextDecoder.get(enc);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public TextInput validate(boolean flag) {
        this.validate = flag;
        this.decoder.validate = flag;
        return this;
    }

    public TextInput encoding(String encoding) throws IOException {
        if (encoding != null && !encoding.isEmpty()) {
            String enc = Strings.normEncoding(encoding, false);
            this.decoder = TextDecoder.get(enc != "UTF-16" ? enc : (this.decoder.encoding.equals("UTF-16LE") ? "UTF-16LE" : "UTF-16BE"));
            this.decoder.validate = this.validate;
        }
        return this;
    }

    public String encoding() {
        return this.decoder.encoding;
    }

    @Override
    public int read() throws IOException {
        int cp = this.decoder.read(this);
        if (cp != -1 && !XMLToken.valid(cp)) {
            if (this.validate) {
                throw new InputException(cp);
            }
            return 65533;
        }
        return cp;
    }

    @Override
    public final byte[] content() throws IOException {
        return this.cache().finish();
    }

    public final TokenBuilder cache() throws IOException {
        try {
            int ch;
            TokenBuilder tb = new TokenBuilder(Array.initialCapacity(this.length));
            while ((ch = this.read()) != -1) {
                tb.add(ch);
            }
            TokenBuilder tokenBuilder = tb;
            return tokenBuilder;
        }
        finally {
            this.close();
        }
    }
}

