/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.util.Date;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.DateTime;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class Dtm
extends ADate {
    public static final Dtm ZERO = Dtm.get(0L);

    public Dtm(ADate date, Type type, InputInfo info) throws QueryException {
        super(type, date);
        if (type == AtomType.DATE_TIME_STAMP && !this.hasTz()) {
            throw QueryError.MISSINGZONE_X.get(info, date);
        }
        if (this.hour == -1) {
            this.hour = 0;
            this.minute = 0;
            this.seconds = BigDecimal.ZERO;
        }
    }

    public Dtm(Dat date, Tim time, InputInfo info) throws QueryException {
        super(AtomType.DATE_TIME, date);
        this.hour = time.hour;
        this.minute = time.minute;
        this.seconds = time.seconds;
        if (this.tz == Short.MAX_VALUE) {
            this.tz = time.tz;
        } else if (this.tz != time.tz && time.tz != Short.MAX_VALUE) {
            throw QueryError.FUNZONE_X_X.get(info, date, time);
        }
    }

    public Dtm(byte[] dateTime, Type type, InputInfo info) throws QueryException {
        super(type);
        int i = Token.indexOf(dateTime, 84);
        if (i == -1) {
            throw this.dateError(dateTime, "2000-12-31T23:59:59.999", info);
        }
        this.date(Token.substring(dateTime, 0, i), "2000-12-31T23:59:59.999", info);
        this.time(Token.substring(dateTime, i + 1), "2000-12-31T23:59:59.999", info);
    }

    public Dtm(Dtm dateTime, Dur dur, boolean plus, InputInfo info) throws QueryException {
        this(dateTime, dateTime.type, info);
        if (dur instanceof DTDur) {
            DTDur dtd = (DTDur)dur;
            this.calc(dtd, plus);
            if (this.year <= -25252734927766554L || this.year > 25252734927766554L) {
                throw QueryError.YEARRANGE_X.get(info, this.year);
            }
        } else {
            this.calc((YMDur)dur, plus, info);
        }
    }

    @Override
    public Dtm timeZone(DTDur dur, boolean undefined, InputInfo info) throws QueryException {
        Dtm dtm = new Dtm(this, (Type)AtomType.DATE_TIME, info);
        dtm.tz(dur, undefined, info);
        return dtm;
    }

    public static Dtm get(long ms) {
        try {
            return new Dtm(Token.token(DateTime.format(new Date(ms))), (Type)AtomType.DATE_TIME_STAMP, null);
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    @Override
    public boolean comparable(Item item) {
        return item instanceof Dtm;
    }
}

