/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.function.Predicate;
import org.basex.core.jobs.Job;
import org.basex.data.Data;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.io.in.TextInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Itr;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public abstract class Item
extends Value {
    public static final int NAN_DUMMY = Integer.MIN_VALUE;

    protected Item(Type type) {
        super(type);
    }

    @Override
    public void write(DataOutput out) throws IOException, QueryException {
        out.writeToken(this.string(null));
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(1L){

            @Override
            public Item get(long i) {
                return Item.this;
            }

            @Override
            public boolean valueIter() {
                return true;
            }

            @Override
            public Item value(QueryContext qc, Expr expr) {
                return Item.this;
            }
        };
    }

    @Override
    public final Item item(QueryContext qc, InputInfo ii) {
        return this;
    }

    @Override
    public final Item itemAt(long index) {
        return this;
    }

    @Override
    public final Item reverse(Job job) {
        return this;
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        return this.bool(ii);
    }

    public abstract byte[] string(InputInfo var1) throws QueryException;

    public boolean bool(InputInfo ii) throws QueryException {
        throw QueryError.testError(this, false, ii);
    }

    public BigDecimal dec(InputInfo ii) throws QueryException {
        return Dec.parse(this.string(ii), ii, true);
    }

    public long itr(InputInfo ii) throws QueryException {
        return Itr.parse(this.string(ii), ii);
    }

    public float flt(InputInfo ii) throws QueryException {
        return Flt.parse(this.string(ii), ii);
    }

    public double dbl(InputInfo ii) throws QueryException {
        return Dbl.parse(this.string(ii), ii);
    }

    public boolean instanceOf(Type tp, boolean coerce) {
        return this.type.instanceOf(tp);
    }

    public boolean comparable(Item item) {
        return this.type == item.type;
    }

    public boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        return this.atomicEqual(item);
    }

    public boolean atomicEqual(Item item) throws QueryException {
        return this == item || this.comparable(item) && this.compare(item, null, false, null) == 0;
    }

    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        throw QueryError.compareError(this, item, ii);
    }

    public BufferInput input(InputInfo ii) throws QueryException {
        return new ArrayInput(this.string(ii));
    }

    public TextInput stringInput(InputInfo ii) throws IOException, QueryException {
        return new TextInput(new IOContent(this.string(ii)));
    }

    @Override
    public final Item subSeq(long start, long length, Job job) {
        throw Util.notExpected();
    }

    @Override
    public Value insertValue(long pos, Value value, Job job) {
        ValueBuilder vb = new ValueBuilder(job, value.size() + 1L);
        vb.add(pos == 0L ? value : this);
        vb.add(pos == 0L ? this : value);
        return vb.value(this.type.union(value.type));
    }

    @Override
    public final Item removeItem(long pos, Job job) {
        throw Util.notExpected();
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return this;
    }

    @Override
    public Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        return this;
    }

    @Override
    public Item materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        return this;
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        return true;
    }

    @Override
    public SeqType seqType() {
        return this.type.seqType();
    }

    @Override
    public long size() {
        return 1L;
    }

    @Override
    public void refineType(Expr expr) {
    }

    @Override
    public boolean refineType() throws QueryException {
        return true;
    }

    @Override
    public Item shrink(Job job) throws QueryException {
        return this;
    }

    @Override
    protected Item rebuild(Job job) throws QueryException {
        return this;
    }

    @Override
    public final boolean ddo() {
        return this.type instanceof NodeType;
    }

    public double score() {
        return 0.0;
    }

    public byte[] xdmInfo() {
        return new byte[]{this.typeId().asByte()};
    }

    public Type.ID typeId() {
        return this.type.id();
    }

    @Override
    public String description() {
        return this.type == AtomType.ITEM ? "item" : String.valueOf(this.type) + " item";
    }

    @Override
    public void toXml(QueryPlan plan) {
        try {
            plan.add(plan.create(this, new Object[0]), new Object[]{QueryString.toValue(this.string(null))});
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }
}

