/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.EnumMap;
import org.basex.io.in.DataInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ChoiceItemType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class EnumType
implements Type {
    private final TokenSet values;
    private EnumMap<Occ, SeqType> seqTypes;

    public EnumType(TokenSet values) {
        this.values = values;
    }

    @SafeVarargs
    public static <T> EnumType get(T ... values) {
        TokenSet set = new TokenSet(values.length);
        for (T value : values) {
            set.add(value.toString());
        }
        return new EnumType(set);
    }

    public boolean instance(Item item) {
        try {
            return item.type.instanceOf(AtomType.STRING) && this.values.contains(item.string(null));
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    @Override
    public Value cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
        byte[] string = item.string(info);
        if (!this.values.contains(string)) {
            throw QueryError.typeError(item, this, info);
        }
        return item.type.eq(this) ? item : Str.get(string, new EnumType(new TokenSet(new byte[][]{string})));
    }

    @Override
    public Value cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
        return this.cast(Str.get(value, qc, info), qc, info);
    }

    @Override
    public Item read(DataInput in, QueryContext qc) {
        throw Util.notExpected();
    }

    @Override
    public SeqType seqType(Occ occ) {
        if (this.seqTypes == null) {
            this.seqTypes = new EnumMap(Occ.class);
        }
        return this.seqTypes.computeIfAbsent(occ, o -> new SeqType(this, (Occ)((Object)o)));
    }

    @Override
    public boolean eq(Type type) {
        return this.equals(type);
    }

    @Override
    public boolean instanceOf(Type type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ChoiceItemType) {
            ChoiceItemType cit = (ChoiceItemType)type;
            return cit.hasInstance(this);
        }
        if (AtomType.STRING.instanceOf(type)) {
            return true;
        }
        if (!(type instanceof EnumType)) {
            return false;
        }
        EnumType et = (EnumType)type;
        for (byte[] value : this.values) {
            if (et.values.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type union(Type type) {
        if (type == this) {
            return this;
        }
        if (type instanceof ChoiceItemType) {
            return type.union(this);
        }
        if (type instanceof EnumType) {
            EnumType et = (EnumType)type;
            TokenSet tv = et.values;
            TokenSet ts = new TokenSet();
            for (byte[] value : this.values) {
                ts.add(value);
            }
            for (byte[] value : tv) {
                ts.add(value);
            }
            int sz = ts.size();
            return sz == this.values.size() ? this : (sz == tv.size() ? et : new EnumType(ts));
        }
        return type.instanceOf(AtomType.STRING) ? AtomType.STRING : (type.instanceOf(AtomType.ANY_ATOMIC_TYPE) ? AtomType.ANY_ATOMIC_TYPE : AtomType.ITEM);
    }

    @Override
    public Type intersect(Type type) {
        if (type instanceof ChoiceItemType) {
            return type.intersect(this);
        }
        if (this.instanceOf(type)) {
            return this;
        }
        if (type instanceof EnumType) {
            EnumType et = (EnumType)type;
            TokenSet ts = new TokenSet();
            TokenSet tv = et.values;
            for (byte[] value : this.values) {
                if (!tv.contains(value)) continue;
                ts.add(value);
            }
            for (byte[] value : tv) {
                if (!this.values.contains(value)) continue;
                ts.add(value);
            }
            int sz = ts.size();
            if (sz > 0) {
                return sz == this.values.size() ? this : (sz == tv.size() ? et : new EnumType(ts));
            }
        }
        return null;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isUntyped() {
        return false;
    }

    @Override
    public boolean isNumberOrUntyped() {
        return false;
    }

    @Override
    public boolean isStringOrUntyped() {
        return true;
    }

    @Override
    public boolean isSortable() {
        return true;
    }

    @Override
    public AtomType atomic() {
        return AtomType.STRING;
    }

    @Override
    public Type.ID id() {
        return Type.ID.ENM;
    }

    @Override
    public boolean nsSensitive() {
        return false;
    }

    public int hashCode() {
        int h = 0;
        for (byte[] v : this.values) {
            h = h * 31 + Token.hashCode(v);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnumType)) {
            return false;
        }
        EnumType et = (EnumType)obj;
        TokenSet tv = et.values;
        if (this.values.size() != tv.size()) {
            return false;
        }
        for (byte[] value : this.values) {
            if (tv.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        QueryString qs = new QueryString().token("enum(");
        int i = 0;
        for (byte[] value : this.values) {
            if (i++ != 0) {
                qs.token(',').token(' ');
            }
            qs.quoted(value);
        }
        return qs.token(')').toString();
    }
}

