/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.Objects;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;

public final class RecordField {
    final boolean optional;
    final SeqType seqType;
    private final Expr expr;

    public RecordField(SeqType seqType) {
        this(seqType, false);
    }

    public RecordField(SeqType seqType, boolean optional) {
        this(seqType, optional, null);
    }

    public RecordField(SeqType seqType, boolean optional, Expr expr) {
        this.seqType = seqType != null ? seqType : Types.ITEM_ZM;
        this.optional = optional;
        this.expr = expr;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Expr expr() {
        return this.expr;
    }

    public SeqType seqType() {
        return this.seqType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof RecordField)) return false;
        RecordField rf = (RecordField)obj;
        if (this.optional != rf.optional) return false;
        if (!this.seqType.eq(rf.seqType)) return false;
        if (!Objects.equals(this.expr, rf.expr)) return false;
        return true;
    }

    public String toString() {
        QueryString qs = new QueryString();
        if (this.optional) {
            qs.token('?');
        }
        qs.token("as").token(this.seqType());
        return qs.toString();
    }
}

