/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.net.URI;
import java.util.ArrayList;
import javax.xml.catalog.Catalog;
import javax.xml.catalog.CatalogFeatures;
import javax.xml.catalog.CatalogManager;
import javax.xml.transform.URIResolver;
import org.basex.core.BaseXException;
import org.basex.io.IO;
import org.basex.util.Reflect;
import org.basex.util.Strings;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;

public final class XMLResolver {
    private static final String RESOLVER = "org.xmlresolver.Resolver";
    private static final String CONFIGURATION = "org.xmlresolver.XMLResolverConfiguration";
    private final String catalog;
    private Object resolver;

    public XMLResolver(Object resolver) throws BaseXException {
        Class[] clzzs;
        Class<?> rclzz = resolver.getClass();
        for (Class clzz : clzzs = new Class[]{EntityResolver.class, LSResourceResolver.class, URIResolver.class}) {
            if (clzz.isAssignableFrom(rclzz)) continue;
            throw new BaseXException("% does not implement the interface %", resolver, clzz);
        }
        this.resolver = resolver;
        this.catalog = "";
    }

    public XMLResolver(String catalog) {
        this.catalog = catalog;
    }

    public String catalog() {
        return this.catalog;
    }

    public boolean standard() {
        return this.resolver == null && this.catalog.isEmpty();
    }

    public EntityResolver entityResolver() {
        return (EntityResolver)this.resolver();
    }

    public URIResolver uriResolver() {
        return (URIResolver)this.resolver();
    }

    public LSResourceResolver lsResourceResolver() {
        return (LSResourceResolver)this.resolver();
    }

    private Object resolver() {
        if (this.resolver == null && !this.catalog.isEmpty()) {
            if (Reflect.available(RESOLVER, new Object[0])) {
                Class<?> rslvr = Reflect.find(RESOLVER);
                Class<?> cnfgrtn = Reflect.find(CONFIGURATION);
                Object cnf = Reflect.get(Reflect.find(cnfgrtn, String.class), this.catalog);
                this.resolver = Reflect.get(Reflect.find(rslvr, cnfgrtn), cnf);
            } else {
                ArrayList<URI> uris = new ArrayList<URI>();
                for (String cat : Strings.split(this.catalog, ';')) {
                    uris.add(URI.create(IO.get(cat).url()));
                }
                CatalogFeatures cf = CatalogFeatures.defaults();
                Catalog cat = CatalogManager.catalog(cf, (URI[])uris.toArray(URI[]::new));
                this.resolver = CatalogManager.catalogResolver(cat);
            }
        }
        return this.resolver;
    }
}

