/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ARef;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.RT;
import java.util.concurrent.atomic.AtomicReference;

public final class Atom
extends ARef {
    final AtomicReference state;

    public Atom(Object state) {
        this.state = new AtomicReference<Object>(state);
    }

    public Atom(Object state, IPersistentMap meta) {
        super(meta);
        this.state = new AtomicReference<Object>(state);
    }

    @Override
    public Object deref() {
        return this.state.get();
    }

    public Object swap(IFn f) {
        Object newv;
        Object v;
        do {
            v = this.deref();
            newv = f.invoke(v);
            this.validate(newv);
        } while (!this.state.compareAndSet(v, newv));
        this.notifyWatches(v, newv);
        return newv;
    }

    public Object swap(IFn f, Object arg) {
        Object newv;
        Object v;
        do {
            v = this.deref();
            newv = f.invoke(v, arg);
            this.validate(newv);
        } while (!this.state.compareAndSet(v, newv));
        this.notifyWatches(v, newv);
        return newv;
    }

    public Object swap(IFn f, Object arg1, Object arg2) {
        Object newv;
        Object v;
        do {
            v = this.deref();
            newv = f.invoke(v, arg1, arg2);
            this.validate(newv);
        } while (!this.state.compareAndSet(v, newv));
        this.notifyWatches(v, newv);
        return newv;
    }

    public Object swap(IFn f, Object x, Object y, ISeq args) {
        Object newv;
        Object v;
        do {
            v = this.deref();
            newv = f.applyTo(RT.listStar(v, x, y, args));
            this.validate(newv);
        } while (!this.state.compareAndSet(v, newv));
        this.notifyWatches(v, newv);
        return newv;
    }

    public boolean compareAndSet(Object oldv, Object newv) {
        this.validate(newv);
        boolean ret = this.state.compareAndSet(oldv, newv);
        if (ret) {
            this.notifyWatches(oldv, newv);
        }
        return ret;
    }

    public Object reset(Object newval) {
        Object oldval = this.state.get();
        this.validate(newval);
        this.state.set(newval);
        this.notifyWatches(oldval, newval);
        return newval;
    }
}

