// (c) Microsoft Corporation 2005-2007.  

#light

module Microsoft.FSharp.Core.Pervasives

open System
open Microsoft.FSharp
open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Text
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Compatibility
open Microsoft.FSharp.Primitives.Basics

let (^) (x:string) (y:string) = System.String.Concat(x,y)

let (@) l1 l2 = Primitives.Basics.(@) l1 l2

let incr x = x.contents <- x.contents + 1
let decr x = x.contents <- x.contents - 1
let seq (x : #seq<_>) = (x :> seq<_>)
let truncate (x:float) = int x

let complex r i = Math.Notation.complex r i
let matrix ll = Math.Notation.matrix ll
let vector l = Math.Notation.vector l
let rowvec l = Math.Notation.rowvec l
let set l = Collections.Set.of_seq l
#if CLI_AT_MOST_1_1
#else
let dict l = (Map.of_seq l :> System.Collections.Generic.IDictionary<_,_>)
#endif   

// --------------------------------------------------------------------
// Printf
// -------------------------------------------------------------------- 

let sprintf fp  = Printf.sprintf fp
let failwithf fp  = Printf.failwithf fp
let fprintf os fp  = Printf.fprintf os fp 
let printf fp = Printf.printf fp 
let eprintf fp = Printf.eprintf fp 
let fprintfn os fp  = Printf.fprintfn os fp 
let printfn fp = Printf.printfn fp 
let eprintfn fp = Printf.eprintfn fp 

let failwith s = raise (Failure s)
let exit (n:int) = System.Environment.Exit(n); failwith "System.Environment.Exit did not exit!"

type FormatOptions = Microsoft.FSharp.Text.StructuredFormat.FormatOptions

let any_to_layout opts x = Microsoft.FSharp.Text.StructuredFormat.Display.any_to_layout opts x
let squash_layout opts x = Microsoft.FSharp.Text.StructuredFormat.Display.squash_layout opts x
let output_layout opts (oc:#System.IO.TextWriter) x = Microsoft.FSharp.Text.StructuredFormat.Display.output_layout opts oc x
let layout_to_string opts x = Microsoft.FSharp.Text.StructuredFormat.Display.layout_to_string opts x
let layout_as_string opts x = Microsoft.FSharp.Text.StructuredFormat.Display.layout_as_string opts x
let output_any (oc:#System.IO.TextWriter) x = Microsoft.FSharp.Text.StructuredFormat.Display.output_any oc x
let any_to_string x = Microsoft.FSharp.Text.StructuredFormat.Display.any_to_string x

let print_any x = output_any System.Console.Out x
let print x = print_any x
let prerr_any x = output_any System.Console.Out x

#if CLI_AT_MOST_1_1
#else
let async = Microsoft.FSharp.Control.Async.async
#endif   


