// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp

open Microsoft.FSharp.Core
open Microsoft.FSharp.Control
open Microsoft.FSharp.Collections
open System


[<Obsolete("The Idioms module should no longer be used. All operations have alternative, direct equivalents, normally in 'Microsoft.FSharp.Core.Operators', which is opened by default")>]
module Idioms = 

    //--------------------------------------------------------------------------
    // The .NET object model: locks
    //--------------------------------------------------------------------------
     
    [<Obsolete("The 'using' operator is now defined in Microsoft.FSharp.Core.Operators, which is opened by default. Avoid using or opening the Idioms module which is now obsolete")>]
    val lock: #System.Object -> (unit -> 'a) -> 'a 

    //--------------------------------------------------------------------------
    // The .NET object model: "using" via IDisposable (i.e. auto-cleanup)
    //
    // F#-generated types do not directly implement IDisposable unless an
    // explicit augmentation is used. However it is easy to project
    // F# values into IDisposable values. For example
    //
    //    let autocleanup (close : 'a -> unit) (x: 'a) =
    //       {new IDisposable with Dispose()= close x}
    //
    //    ...
    //
    //    let myChannel = open_in "hello.txt" in
    //    using (autocleanup close_in myChannel) begin fun () ->
    //      ...
    //    end
    //--------------------------------------------------------------------------

     
    [<Obsolete("The 'using' operator is now defined in Microsoft.FSharp.Core.Operators, which is opened by default. Avoid using or opening the Idioms module which is now obsolete")>]
    val using: ('a :> System.IDisposable) -> ('a -> 'b) -> 'b


    //--------------------------------------------------------------------------
    // C# idioms: foreach/foreachG
    //--------------------------------------------------------------------------

    /// This idiom corresponds to the C# "foreach" construct.
    /// Use as: 'foreach (collection) (fun (x:expectedType) -&gt; ...)'.
    /// Try using 'Idioms.foreachG' before using this function, as that
    /// detects if the collection supports a typesafe IEnumerable&lt;T&gt;.
    /// If any element of the heterogeneous collection does not
    /// have the given type then a runtime error will be raised.
    /// Not all F# collection types directly implement the required interfaces,
    /// hence you may need to call a projection function such as 'CollectionType.to_IEnumerable'.
    [<Obsolete("Consider using 'for x in enumerable do ...' instead")>]
    val foreach: #System.Collections.IEnumerable -> ('a -> unit) -> unit

    #if CLI_AT_LEAST_2_0
    /// Enumerator iteration. See 'foreach'.
    [<Obsolete("Consider using 'for x in enumerable do ...' or Seq.iter instead")>]
    val foreachG: #System.Collections.Generic.IEnumerable<'a> -> ('a -> unit) -> unit
    #endif

    /// Convert a value from the univeral representation type 'obj' to another type,
    /// where the result type is inferred from context.
    [<Obsolete("The 'unbox' operator is now defined in Microsoft.FSharp.Core.Operators, which is opened by default. Avoid using or opening the Idioms module which is now obsolete")>]
    val unbox: obj -> 'a  

    /// Convert a value to the univeral representation type 'obj',
    /// where the argument type is inferred from context.
    [<Obsolete("The 'unbox' operator is now defined in Microsoft.FSharp.Core.Operators, which is opened by default. Avoid using or opening the Idioms module which is now obsolete")>]
    val box: 'a -> obj    

    //--------------------------------------------------------------------------
    // The .NET object model: typeof
    //
    //--------------------------------------------------------------------------

    [<Obsolete("This type is now defined in Microsoft.FSharp.Core, which is opened by default. Avoid using or opening the Idioms module which is now obsolete")>]
    type 'a typ = 'a Microsoft.FSharp.Core.ReifiedType

    [<Obsolete("Consider using typeof<type> instead")>]
    #if CLI_AT_LEAST_2_0
    val inline typeof: unit -> 'a typ
    #else
    val inline typeof: unit -> $a typ
    #endif

    type 'a sizeof = { result: int }

    [<Obsolete("The 'sizeof' operator is now defined in Microsoft.FSharp.Core.Operators, which is automaticlly opened, and used as 'sizeof<type>'. Avoid using or opening the Idioms module which is now obsolete")>]
    #if CLI_AT_LEAST_2_0
    val sizeof: unit -> 'a sizeof
    #else
    val inline sizeof: unit -> $a sizeof
    #endif

    //--------------------------------------------------------------------------
    // The .NET method model: param arrays
    //--------------------------------------------------------------------------

    /// Use when calling a method from another .NET language that expects a variable number of
    /// arguments.
    #if CLI_AT_LEAST_2_0
    [<Obsolete("Consider using an array expression '[| arg1; ...; argN |]' rather than the 'ParamArray' function")>]
    val ParamArray: 'a list -> 'a[]
    #else
    val inline ParamArray: $a list -> $a[]
    #endif

    //-------------------------------------------------------------------------
    // Events
    //

    /// See Microsoft.FSharp.Control.IEvent
    [<Obsolete("The 'IEvent' type is now defined in Microsoft.FSharp.Control, which is opened by default. Avoid using or opening the Idioms module which is now obsolete")>]
    type IEvent<'a> = Microsoft.FSharp.Control.IEvent<'a>

    /// See Microsoft.FSharp.IDelegateEvent
    [<Obsolete("The 'IDelegateEvent' type is now defined in Microsoft.FSharp.Control, which is opened by default. Avoid using or opening the Idioms module which is now obsolete")>]
    type IDelegateEvent<'del,'args> = Microsoft.FSharp.Control.IDelegateEvent<'del,'args>

    /// Fresh events declared in F# are typically values of type Idioms.ICompatEvent&lt;'a&gt;. These 
    /// hold event handlers of type Idioms.Handler&lt;'a&gt;. 

    [<Obsolete("The 'Handler' type is now defined in Microsoft.FSharp.Control, which is opened by default. Avoid using or opening the Idioms module which is now obsolete")>]
    type Handler<'a> =  Microsoft.FSharp.Control.Handler<'a>

    [<Obsolete("This type has been renamed Microsoft.FSharp.Control.IHandlerEvent")>]
    type IHandlerEvent<'a> = Microsoft.FSharp.Control.IHandlerEvent<'a>


    [<Obsolete("Consider using IEvent.create_HandlerEvent instead")>]
    type EventListeners<'a> 
      with
        /// Fire the event associated with this EventListeners store
        member Fire: 'a -> unit
        /// Return the IEvent object that mediates access to this store.
        member Event: Microsoft.FSharp.Control.IHandlerEvent<'a>
        /// Build a new store of listeneres for an event
        new: unit -> EventListeners<'a>
      end

    //--------------------------------------------------------------------------
    // The .NET object model: enums
    //
    // F# does not directly associate .NET enumerations with their underlying
    // integer types. However, this makes it inconvenient to perform certain
    // operations like bitwise-or and bitwise-and on flag enumerations.
    // Hence the following functions are provided.
    //
    // NOTE: These are now deprecated in favour of Enum.to_int, Enum.combine etc.
    //
    // EnumToInt/IntToEnum: Convert enum types to and from integers.
    //
    // CombineEnumFlags: Perform a "logical or" on the given enumeration values.
    // TestEnumFlags: Perform a "logical or" on the given enumeration values.
    //
    // A future release of F# may statically checked that
    // 'a is a .NET enumeration type, and the operations will be more efficient.
    // Currently they box/unbox, resulting in a dynamic type check, and thus may 
    // fail.
    //--------------------------------------------------------------------------

    /// Convert an enumeration value to an integer. The argument type is inferred from context.
    [<Obsolete("Consider using Enum.to_int instead")>] 
    val EnumToInt: 'a -> int             when 'a :> System.Enum
    /// Convert an integer to an enumeration value. The result type is inferred from context.
    [<Obsolete("Consider using Enum.of_int instead")>] 
    val IntToEnum: int -> 'a             when 'a :> System.Enum

    /// Combine enum values using 'logical or'. The relevant enumeration type is inferred from context.
    [<Obsolete("Consider using '|||' instead")>] 
    val CombineEnumFlags: 'a list -> 'a  when 'a :> System.Enum

    /// Test if an enumeration value has a particular flag set, using 'logical and'. 
    /// The relevant enumeration type is inferred from context.
    [<Obsolete("Consider using Enum.test instead")>] 
    val TestEnumFlag: 'a -> 'a -> bool   when 'a :> System.Enum
