// (c) Microsoft Corporation 2005-2007.  

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Int64 = 

    let compare (x:int64) y = compare x y

    let zero = 0L
    let one = 1L
    let minus_one = -1L
    let neg (x:int64) =  -x
    let add (x:int64) (y:int64) = x + y
    let sub (x:int64) (y:int64) = x - y
    let mul (x:int64) (y:int64) = x * y
    let div (x:int64) (y:int64) = x / y
    let rem (x:int64) (y:int64) = x % y
    let succ (x:int64) = x + 1L
    let pred (x:int64) = x - 1L
    let abs (x:int64) = if x < zero then neg x else x
    let max_int = 0x7FFFFFFFFFFFFFFFL
    let min_int = 0x8000000000000000L
    let logand (x:int64) (y:int64) = x &&& y
    let logor (x:int64) (y:int64) = x ||| y
    let logxor (x:int64) (y:int64) = x ^^^ y
    let lognot (x:int64) = ~~~x
    let shift_left (x:int64) (n:int) =  x <<< n
    let shift_right (x:int64) (n:int) =  x >>> n
    let of_int (n:int) =  (# "conv.i8" n : int64 #)
    let to_int (x:int64) = (# "conv.i4" x : int #)
    let of_int32 (n:int32) =  (# "conv.i8" n : int64 #)
    let to_int32 (x:int64) = (# "conv.i4" x : int32 #)
    let of_uint64 (n:uint64) =  (# "conv.i8" n : int64 #)
    let to_uint64 (x:int64) = (# "conv.u8" x : uint64 #)
    let shift_right_logical (x:int64) (n:int) =  of_uint64 (to_uint64 x >>> n)

    let of_nativeint (n:nativeint) =  (# "conv.i8" n : int64 #)
    let to_nativeint (x:int64) = (# "conv.i" x : nativeint #)
    let of_float (f:float) =  (# "conv.i8" f : int64 #)
    let to_float (x:int64) =  (# "conv.r8" x : float #)
    let of_string (s:string) = 
      try
        let l = s.Length in 
        let p = 0 in 
        let p,sign = if (l >= p + 1 && s.[p] = '-') then 1,(-1L) else 0,1L in 
        let p,specifier = if (l >= p + 2 && s.[p] = '0' && (let c = System.Char.ToLower s.[p+1] in c = 'x' || c = 'o' || c = 'b')) then p+2,s.[p+1] else p,'d' in 
        if p >= l then raise (new System.FormatException()) 
        else
            match System.Char.ToLower specifier with 
            | 'x' -> 
              sign * System.Int64.Parse(s.[p..], System.Globalization.NumberStyles.AllowHexSpecifier,System.Globalization.CultureInfo.InvariantCulture)
            | 'b' -> 
              let rec parse n acc = if n < l then parse (n+1) (acc * 2L + (match s.[n] with '0' -> 0L | '1' -> 1L | _ -> raise (new System.FormatException()))) else acc in          
              sign * parse p 0L
            | 'o' -> 
              let rec parse n acc = if n < l then parse (n+1) (acc * 8L + (let c = s.[n] in if c >= '0' && c <= '7' then System.Convert.ToInt64(c) - System.Convert.ToInt64('0') else raise (new System.FormatException()))) else acc in
              sign * parse p 0L
            | _ -> 
              System.Int64.Parse(s, System.Globalization.CultureInfo.InvariantCulture)
      with :? System.FormatException -> failwith "Int64.of_string"

    let to_string (x:int64) = (box x).ToString()

    let bits_of_float (x:float) = System.BitConverter.DoubleToInt64Bits(x)
    let float_of_bits (x:int64) = System.BitConverter.Int64BitsToDouble(x)


    let of_float32 (f:float32) =  (# "conv.i8" f : int64 #)
    let to_float32 (x:int64) =  (# "conv.r4" x : float32 #)

