// (c) Microsoft Corporation 2005-2007.

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module UInt32 = 

    let compare (x:uint32) y = compare x y

    let zero = 0ul
    let one = 1ul
    let add (x:uint32) (y:uint32) = x + y
    let sub (x:uint32) (y:uint32) = x - y
    let mul (x:uint32) (y:uint32) = x * y
    let div (x:uint32) (y:uint32) = x / y
    let rem (x:uint32) (y:uint32) = x % y
    let succ (x:uint32) = x + 1ul
    let pred (x:uint32) = x - 1ul
    let max_int = 0xFFFFFFFFul
    let min_int = 0ul 
    let logand (x:uint32) (y:uint32) = x &&& y
    let logor (x:uint32) (y:uint32) = x ||| y
    let logxor (x:uint32) (y:uint32) = x ^^^ y
    let lognot (x:uint32) = ~~~x
    let shift_left (x:uint32) (n:int) =  x <<< n
    let shift_right (x:uint32) (n:int) =  x >>> n
    let of_int (n:int) =  (# "conv.u4" n : uint32 #)
    let to_int (x:uint32) = (# "conv.i4" x : int #)
    let of_int32 (n:int32) =  (# "conv.u4" n : uint32 #)
    let to_int32 (x:uint32) = (# "conv.i4" x : int32 #)

    let of_float (f:float) =  (# "conv.u4" f : uint32 #)
    let to_float (x:uint32) =  (# "conv.r.un conv.r8" x : float #)

    let of_string (s:string) = 
      try
        let l = s.Length in 
        let p = 0 in 
        let p,specifier = if (l >= p + 2 && s.[p] = '0' && (let c = s.[p+1] in c = 'x' || c = 'o' || c = 'b')) then p+2,s.[p+1] else p,'d' in 
        if p >= l then raise (new System.FormatException()) 
        else
          let v = 
            match specifier with 
            | 'x' -> System.UInt32.Parse(s.[p..], System.Globalization.NumberStyles.AllowHexSpecifier,System.Globalization.CultureInfo.InvariantCulture)
            | 'b' -> 
              let rec parse n acc = if n < l then parse (n+1) (acc * 2ul + (match s.[n] with '0' -> 0ul | '1' -> 1ul | _ -> raise (new System.FormatException()))) else acc in          
              parse p 0ul
            | 'o' -> 
              let rec parse n acc = if n < l then parse (n+1) (acc * 8ul + (let c = s.[n] in if c >= '0' && c <= '7' then System.Convert.ToUInt32(c) - System.Convert.ToUInt32('0') else raise (new System.FormatException()))) else acc in
              parse p 0ul
            | _ -> System.UInt32.Parse(s.[p..], System.Globalization.CultureInfo.InvariantCulture) in
          v 
      with :? System.FormatException -> failwith "UInt32.of_string"

    let to_string (x:uint32) = (box x).ToString()

    let bits_of_float32 (x:float32) = 
        System.BitConverter.ToUInt32(System.BitConverter.GetBytes(x),0)
          
    let float32_of_bits (x:uint32) = 
        System.BitConverter.ToSingle(System.BitConverter.GetBytes(x),0)

    let float32_to_float (x:float32) = (# "conv.r8" x : float #)
    let float_to_float32 (x:float) = (# "conv.r4" x : float32 #)

    let float_of_bits x = float32_to_float (float32_of_bits x)
    let bits_of_float x = bits_of_float32 (float_to_float32 x)

    let of_unativeint (f:unativeint) =  (# "conv.u4" f : uint32 #)
    let to_unativeint (x:uint32) =  (# "conv.u" x : unativeint #)

    let of_uint64 (f:uint64) =  (# "conv.u4" f : uint32 #)
    let to_uint64 (x:uint32) =  (# "conv.u8" x : uint64 #)



    let of_float32 (f:float32) =  (# "conv.u4" f : uint32 #)
    let to_float32 (x:uint32) =  (# "conv.r.un conv.r4" x : float32 #)
