//--------------------------------------------------------------------
// This file is written in F# and defines the interface to
// a software component which publishes some simple types and 
// functions.  The implementation is in FSharpLibrary.fs.  
// Compiling these files using
//
//     fsc -a FSharpLibrary.dll FSharpLibrary.fsi FSharpLibrary.fs
//
// packages them as a DLL which defines a .NET assembly. 
// The types and functions can then be accessed from any .NET 
// language. 
//
// Note that the function MyDataMap accepts a function value 
// as an argument.  
//
// Copyright (c) Microsoft Corporation 2005-2006.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 
//--------------------------------------------------------------------

#light

val PrintIntegers: int -> unit

type MyData =
    | A of string
    | B of int * MyData

val MyDataMap: (int -> int) -> MyData -> MyData

val MyDataPrint: MyData -> unit

