#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <malloc.h>
#include <cor.h>
#include <time.h>

#define EXTAPI extern "C" HRESULT  _declspec(dllexport)


#ifdef CAML_STUBS

extern "C" 
{
#include <caml/mlvalues.h>
#include <caml/alloc.h>
#include <caml/memory.h>
#include <caml/fail.h>
}
#endif // CAML_STUBS

#define IfFailRet(expression,op	) {  HRESULT hr = (expression); if(FAILED(hr)) { return hr; } }

#define IfImplementedAndFailRet(expression, op) \
    {  /* printf("%s\n",op); fflush(stdout); */ \
       HRESULT hr = (expression); \
       if(FAILED(hr) && hr != E_NOTIMPL) {  return hr; } }

#ifdef CAML_STUBS

#define IfFailThrow(expression, op) \
    {  /* printf("%s\n",op); fflush(stdout);  */ \
       HRESULT hr = (expression); \
       if(FAILED(hr)) {    /*   printf("0x%x\n",hr); fflush(stdout);    */ failwith ("failure when " op); } }

#endif

HRESULT PAL_MyCoCreateInstance(REFCLSID   rclsid,
                             REFIID     riid,
                             void     **ppv);

#endif // COMMON_H
