(*==========================================================================
 * (c) Microsoft Corporation 2005-2007.  
 *=========================================================================*)

#light

///Pervasives: Additional bindings available at the top level 
module Microsoft.FSharp.Core.Pervasives

open System
open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Text
open Microsoft.FSharp.Math

/// Concatenate two strings.  The overlaoded operator '+' may also be used.
val (^): string -> string -> string
/// Concatenate two lists.
val (@): 'a list -> 'a list -> 'a list

/// Decrement a mutable reference cell containing an integer
val decr: int ref -> unit

/// Increment a mutable reference cell containing an integer
val incr: int ref -> unit

/// Truncates the digits of a floating point number and returns 
/// the whole number as an integer
[<OCamlCompatibility("This function currently converts floats to 32-bit integers by truncation. A future version of F# is likely to change 'truncate' to be an overloaded operator that works on floats, decimals and other types, and returns the same type as the input. Consider using 'float' or 'Float.to_int' instead in preparation for this change")>]
val truncate: float -> int

/// Convert any value to a string using a standard formatter
/// Data is typically formatted in a structured format, e.g.
/// lists are formatted using the "[1;2]" notation.
/// The details of the format are not specified and may change
/// from version to version and according to the flags given
/// to the F# compiler.  The format is intended to be human-readable,
/// not machine readable.  If alternative generic formats are required
/// you should develop your own formatter, using the code in the
/// implementation of this file as a starting point.
///
/// Data from other .NET languages is formatted using a virtual
/// call to Object.ToString() on the boxed version of the input.
val any_to_string: 'a -> string

/// Ouput any value to a channel using the same set of formatting rules
/// as any_to_string
val output_any: #System.IO.TextWriter -> 'a -> unit

/// Print any value to stdin using any_to_string. 
val print_any : 'a -> unit

/// Print any value to stderr using any_to_string. 
val prerr_any : 'a -> unit

/// A record of options to control structural formatting.
/// For F# Interactive properties matching those of this value can be accessed via the 'fsi'
/// value.
/// 
/// Floating Point format given in the same format accepted by System.Double.ToString,
/// e.g. f6 or g15.
///
/// If ShowProperties is set the printing process will evaluate properties of the values being
/// displayed.  This may cause additional computation.  
///
/// The ShowIEnumerable is set the printing process will force the evalution of IEnumerable objects
/// to a small, finite depth, as determined by the printing parameters.
/// This may lead to additional computation being performed during printing.
///
/// <example>
/// From F# Interactive the default settings can be adjusted using, for example, 
/// <pre>
///   open Microsoft.FSharp.Compiler.Interactive.Settings;;
///   setPrintWidth 120;;
/// </pre>
/// </example>
[<System.Obsolete("This type alias is obsolete. Use Text.StructuredFormat.FormatOptions instead")>]
type FormatOptions = Microsoft.FSharp.Text.StructuredFormat.FormatOptions
 
/// Convert any value to a layout using the given formatting options.  The
/// layout can then be processed using formatting display engines such as
/// those in the LayoutOps module.  any_to_string and output_any are
/// built using any_to_layout with default format options.
val any_to_layout   : FormatOptions -> 'a -> StructuredFormat.Layout
[<System.Obsolete("This function is scheduled for deletion and should no longer be used")>]
val squash_layout   : FormatOptions -> StructuredFormat.Layout -> StructuredFormat.Layout
[<System.Obsolete("This function is scheduled for deletion and should no longer be used")>]
val output_layout   : FormatOptions -> #System.IO.TextWriter -> StructuredFormat.Layout -> unit
[<System.Obsolete("This function is scheduled for deletion and should no longer be used")>]
val layout_to_string: FormatOptions -> StructuredFormat.Layout -> string
val layout_as_string: FormatOptions -> 'a -> string

//--------------------------------------------------------------------------
//Printf.  See the 'Printf' module for other variations on Printf.

/// Print to stdout using the given format
val printf  :                #Printf.TextWriterFormat<'a> -> 'a
/// Print to stdout using the given format, and add a newline
val printfn  :                #Printf.TextWriterFormat<'a> -> 'a
/// Print to stderr using the given format
val eprintf  :               #Printf.TextWriterFormat<'a> -> 'a
/// Print to stderr using the given format, and add a newline
val eprintfn  :               #Printf.TextWriterFormat<'a> -> 'a
/// Print to a string using the given format
val sprintf :                #Printf.StringFormat<'a> -> 'a
/// Print to a string buffer and raise an exception with the given
/// result.   Helper printers must return strings.
val failwithf: #Printf.StringFormat<'a,'d> -> 'a
/// Print to a file using the given format
val fprintf : System.IO.TextWriter -> #Printf.TextWriterFormat<'a> -> 'a
/// Print to a file using the given format, and add a newline
val fprintfn : System.IO.TextWriter -> #Printf.TextWriterFormat<'a> -> 'a

/// Constructs a complex number from both the real and imaginary part.
val complex : float -> float -> complex
/// Builds a matrix from a sequence of sequence of floats.
val matrix : #seq<#seq<float>> -> matrix
/// Builds a (column) vector from a sequence of floats.
val vector : #seq<float> -> vector
/// Builds a (row) vector from a sequence of floats.
val rowvec : #seq<float> -> rowvec
/// Builds a set from a sequence of objects.
val set : #seq<'a> -> Set<'a>
#if CLI_AT_MOST_1_1
#else
//[<Experimental("This type is part of an experimental feature called 'asynchronous workflows'")>]
val async : Microsoft.FSharp.Control.Async.AsyncBuilder  
val dict : #seq<'a * 'b> -> System.Collections.Generic.IDictionary <'a,'b>
val seq : #seq<'a> -> seq<'a>
#endif

/// Exit the current hardware isolated process, if security settings permit,
/// otherwise raise an exception.  Calls System.Environment.Exit.
val exit: int -> 'a   when default 'a : obj

