// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module UInt64 = 

    let compare (x:uint64) y = compare x y

    let zero = 0UL
    let one = 1UL
    let add (x:uint64) (y:uint64) = x + y
    let sub (x:uint64) (y:uint64) = x - y
    let mul (x:uint64) (y:uint64) = x * y
    let div (x:uint64) (y:uint64) = x / y
    let rem (x:uint64) (y:uint64) = x % y
    let succ (x:uint64) = x + 1UL
    let pred (x:uint64) = x - 1UL
    let max_int = 0xFFFFFFFFFFFFFFFFUL
    let min_int = 0x0UL
    let logand (x:uint64) (y:uint64)   = x &&& y
    let logor  (x:uint64) (y:uint64)   = x ||| y
    let logxor (x:uint64) (y:uint64)   = x ^^^ y
    let lognot (x:uint64)              = (# "not" x : uint64 #)
    let shift_left  (x:uint64) (n:int) =  x <<< n
    let shift_right (x:uint64) (n:int) =  x >>> n
    let of_int        (n:int)             =  (# "conv.u8" n : uint64 #)
    let to_int        (x:uint64)          = (# "conv.i4" x : int #)
    let of_uint32     (n:uint32)          = (# "conv.u8" n : uint64 #)
    let to_uint32     (x:uint64)          = (# "conv.u4" x : uint32 #)
    let of_int64      (n:int64)           = (# "conv.u8" n : uint64 #)
    let to_int64      (x:uint64)          = (# "conv.i8" x : int64 #)
    let of_unativeint (n:unativeint)      = (# "conv.u8" n : uint64 #)
    let to_unativeint (x:uint64)          = (# "conv.u" x : unativeint #)
    let of_float      (f:float)           = (# "conv.u8" f : uint64 #)
    let to_float      (x:uint64)          = (# "conv.r.un conv.r8" x : float #)
    let of_string     (s:string) : uint64 = 
      try
        let l = s.Length in 
        let p = 0 in 
        let p,specifier = if (l >= p + 2 && s.[p] = '0' && (let c = s.[p+1] in c = 'x' || c = 'o' || c = 'b')) then p+2,s.[p+1] else p,'d' in 
        if p >= l then raise (new System.FormatException()) 
        else
          let v = 
            match specifier with 
            | 'x' -> System.UInt64.Parse(s.[p..], System.Globalization.NumberStyles.AllowHexSpecifier,System.Globalization.CultureInfo.InvariantCulture)
            | 'b' -> 
              let rec parse n acc = if n < l then parse (n+1) (acc * 2UL + (match s.[n] with '0' -> 0UL | '1' -> 1UL | _ -> raise (new System.FormatException()))) else acc in          
              parse p 0UL
            | 'o' -> 
              let rec parse n acc = if n < l then parse (n+1) (acc * 8UL + (let c = s.[n] in if c >= '0' && c <= '7' then System.Convert.ToUInt64(c) - System.Convert.ToUInt64('0') else raise (new System.FormatException()))) else acc in
              parse p 0UL
            | _ -> System.UInt64.Parse(s.[p..], System.Globalization.CultureInfo.InvariantCulture) in
          v 
      with :? System.FormatException -> failwith "UInt64.of_string"

    let to_string (x:uint64) = (box x).ToString()
    let bits_of_float (x:float) = System.BitConverter.ToUInt64(System.BitConverter.GetBytes(x),0)
    let float_of_bits (x:uint64) = System.BitConverter.ToDouble(System.BitConverter.GetBytes(x),0)

    let of_float32 (f:float32) =  (# "conv.u8" f : uint64 #)
    let to_float32 (x:uint64) =  (# "conv.r.un conv.r4" x : float32 #)
