(* (c) Microsoft Corporation. All rights reserved *)
(*F# 
open Microsoft.Research.AbstractIL 
open Microsoft.Research.AbstractIL.Internal 
open Microsoft.FSharp.Compiler 
module Il = Microsoft.Research.AbstractIL.IL 
F#*) 
open Range
open Ast
open Tast
open Tastops
open Lib
open Infos

(* switches (REVIEW: move to tcConfig) *)
val generalize_inner_polymorphism : bool ref 

(*-------------------------------------------------------------------------
 * the command line compiler (and F# Interactive) interface
 *------------------------------------------------------------------------- *)

type tcEnv 

type autoModuleResolver = (ident -> Tast.modul_ref option)

(* Incremental construction of environments, e.g. for F# Interactive *)
val init_tenv         : Env.tcGlobals -> range -> ccu list -> tcEnv 
val add_nonlocal_ccu  : range -> tcEnv -> ccu          -> tcEnv 
val add_local_top_rooted_mtyp : range -> tcEnv -> modul_typ -> tcEnv
val tc_open_namespace : autoModuleResolver -> range -> range -> tcEnv -> Ast.long_ident -> tcEnv 

type topAttribs =
    { mainMethodAttrs        : attrib list;
      netModuleAttrs : attrib list;
      assemblyAttrs          : attrib list  }

type conditionalDefines = 
    string list

val emptyTopAttrs : topAttribs
val combineTopAttrs : topAttribs -> topAttribs -> topAttribs
      
val typecheckOneImplFile : 
      Env.tcGlobals * niceNameGenerator * Import.assemMap * ccu * autoModuleResolver * (unit -> bool) * conditionalDefines
      -> tcEnv 
      -> Tast.modul_typ option
      -> implFile
      -> topAttribs * Tast.typedImplFile * tcEnv

val typecheckOneSigFile : 
      Env.tcGlobals * niceNameGenerator * Import.assemMap  * ccu  * autoModuleResolver * conditionalDefines
      -> tcEnv                             
      -> sigFile
      -> tcEnv * tcEnv * modul_typ 

(*-------------------------------------------------------------------------
 * exceptions arising from type checking 
 *------------------------------------------------------------------------- *)

exception FunctionExpected of displayEnv * typ * range
exception NotAFunction of displayEnv * typ * range * range
exception Recursion of displayEnv * Ast.ident * typ * typ * range
exception RecursiveUseCheckedAtRuntime of displayEnv * val_ref * range
exception LetRecEvaluatedOutOfOrder of displayEnv * val_ref * val_ref * range
exception LetRecCheckedAtRuntime of range
exception LetRecUnsound of displayEnv * val_ref list * range
exception TyconBadArgs of displayEnv * tycon_ref * int * range
exception UnionConstrWrongArguments of displayEnv * int * int * range
exception Constr_field_wrong_arguments of displayEnv * int * int * range
exception FieldsFromDifferentTypes of displayEnv * recdfield_ref * recdfield_ref * range
exception FieldGivenTwice of displayEnv * recdfield_ref * range
exception MissingFields of string list * range
exception UnitTypeExpected of displayEnv * Tast.typ * bool * range
exception FunctionValueUnexpected of displayEnv * Tast.typ * range
exception UnionPatternsBindDifferentNames of range
exception VarBoundTwice of Ast.ident
exception ValueRestriction of displayEnv * bool * val_spec * local_typar_ref * range
exception FieldNotMutable of displayEnv * recdfield_ref * range
exception ValNotMutable of displayEnv * val_ref * range
exception ValNotLocal of displayEnv * val_ref * range
exception InvalidRuntimeCoercion of displayEnv * typ * typ * range
exception IndeterminateRuntimeCoercion of displayEnv * typ * typ * range
exception IndeterminateStaticCoercion of displayEnv * typ * typ * range
exception StaticCoercionShouldUseBox of displayEnv * typ * typ * range
exception RuntimeCoercionSourceSealed of displayEnv * typ * range
exception CoercionTargetSealed of displayEnv * typ * range
exception UpcastUnnecessary of range
exception TypeTestUnnecessary of range
exception SelfRefObjCtor of bool * range
exception VirtualAugmentationOnNullValuedType of range
exception NonVirtualAugmentationOnNullValuedType of range
exception UseOfAddressOfOperator of range
exception ThreadStaticWarning of range
exception LowerCaseConstructor of range
exception IntfImplInAugmentation of range
exception NonUniqueInferredAbstractSlot of Env.tcGlobals * displayEnv * string * meth_info * meth_info * range
exception IndexOutOfRangeExceptionWarning of range

(*-------------------------------------------------------------------------
 * Collecting and querying the results of type checking (e.g. Visual Studio 
 * Intellisense).  The remainder of this interface should be highly likely to 
 * change.
 *------------------------------------------------------------------------- *)

val tc_field_init : range -> Il.field_init -> Tast.tconst
val nenv_of_tenv : tcEnv -> Nameres.nameResEnv
val denv_of_tenv : tcEnv -> displayEnv
val items_of_tenv : tcEnv -> Nameres.namedItemInEnv namemap

