/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace PostgreSql.Data.NPgClient
{
	internal class PgParameter
	{
		#region Fields

		private PgType	dataType;
		private object	data;

		#endregion

		#region PARAMETERS

		public PgType DataType
		{
			get { return dataType; }
			set { dataType = value; }
		}

		public object Value
		{
			get { return data; }
			set { data = value; }
		}

		#endregion

		#region Constructors

		public PgParameter()
		{
		}

		public PgParameter(int dataType)
		{
			this.dataType = PgDbClient.Types[dataType];
		}

		public PgParameter(int dataType, object data) : this(dataType)
		{
			this.data = data;
		}

		#endregion
	}
}
