/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATABASE)

#include "JSSQLException.h"

#include "KURL.h"
#include "SQLException.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSQLException);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSQLExceptionTableValues[4] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionCode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionMessage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSQLExceptionTable = { 9, 7, JSSQLExceptionTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSQLExceptionConstructorTableValues[9] =
{
    { "UNKNOWN_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionUNKNOWN_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "DATABASE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionDATABASE_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "VERSION_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionVERSION_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TOO_LARGE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionTOO_LARGE_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "QUOTA_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionQUOTA_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SYNTAX_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionSYNTAX_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "CONSTRAINT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionCONSTRAINT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TIMEOUT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionTIMEOUT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSQLExceptionConstructorTable = { 16, 15, JSSQLExceptionConstructorTableValues, 0 };
class JSSQLExceptionConstructor : public DOMConstructorObject {
public:
    JSSQLExceptionConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSQLExceptionConstructor::s_info = { "SQLExceptionConstructor", &DOMConstructorObject::s_info, &JSSQLExceptionConstructorTable, 0 };

JSSQLExceptionConstructor::JSSQLExceptionConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSQLExceptionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSQLExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSQLExceptionConstructor, JSDOMWrapper>(exec, &JSSQLExceptionConstructorTable, this, propertyName, slot);
}

bool JSSQLExceptionConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSQLExceptionConstructor, JSDOMWrapper>(exec, &JSSQLExceptionConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSQLExceptionPrototypeTableValues[9] =
{
    { "UNKNOWN_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionUNKNOWN_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "DATABASE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionDATABASE_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "VERSION_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionVERSION_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TOO_LARGE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionTOO_LARGE_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "QUOTA_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionQUOTA_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SYNTAX_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionSYNTAX_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "CONSTRAINT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionCONSTRAINT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TIMEOUT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLExceptionTIMEOUT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSQLExceptionPrototypeTable = { 16, 15, JSSQLExceptionPrototypeTableValues, 0 };
static const HashTable* getJSSQLExceptionPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSSQLExceptionPrototypeTable);
}

const ClassInfo JSSQLExceptionPrototype::s_info = { "SQLExceptionPrototype", &JSC::JSObjectWithGlobalObject::s_info, 0, getJSSQLExceptionPrototypeTable };

JSObject* JSSQLExceptionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSQLException>(exec, globalObject);
}

bool JSSQLExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSQLExceptionPrototype, JSObject>(exec, getJSSQLExceptionPrototypeTable(exec), this, propertyName, slot);
}

bool JSSQLExceptionPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSQLExceptionPrototype, JSObject>(exec, getJSSQLExceptionPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSSQLExceptionTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSSQLExceptionTable);
}

const ClassInfo JSSQLException::s_info = { "SQLException", &JSDOMWrapper::s_info, 0, getJSSQLExceptionTable };

JSSQLException::JSSQLException(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SQLException> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSSQLException::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSQLExceptionPrototype(exec->globalData(), globalObject, JSSQLExceptionPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSSQLException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSQLException, Base>(exec, getJSSQLExceptionTable(exec), this, propertyName, slot);
}

bool JSSQLException::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSQLException, Base>(exec, getJSSQLExceptionTable(exec), this, propertyName, descriptor);
}

JSValue jsSQLExceptionCode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSQLException* castedThis = static_cast<JSSQLException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SQLException* imp = static_cast<SQLException*>(castedThis->impl());
    JSValue result = jsNumber(imp->code());
    return result;
}


JSValue jsSQLExceptionMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSQLException* castedThis = static_cast<JSSQLException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SQLException* imp = static_cast<SQLException*>(castedThis->impl());
    JSValue result = jsString(exec, imp->message());
    return result;
}


JSValue jsSQLExceptionConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSQLException* domObject = static_cast<JSSQLException*>(asObject(slotBase));
    return JSSQLException::getConstructor(exec, domObject->globalObject());
}

JSValue JSSQLException::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSQLExceptionConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSQLExceptionUNKNOWN_ERR(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSQLExceptionDATABASE_ERR(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSQLExceptionVERSION_ERR(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSQLExceptionTOO_LARGE_ERR(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsSQLExceptionQUOTA_ERR(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsSQLExceptionSYNTAX_ERR(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

JSValue jsSQLExceptionCONSTRAINT_ERR(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(6));
}

JSValue jsSQLExceptionTIMEOUT_ERR(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(7));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SQLException* impl)
{
    return wrap<JSSQLException>(exec, globalObject, impl);
}

SQLException* toSQLException(JSC::JSValue value)
{
    return value.inherits(&JSSQLException::s_info) ? static_cast<JSSQLException*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(DATABASE)
