/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.IOException;
import java.util.Hashtable;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.optimizer.Block;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

class Optimizer {
    static final int NoType = 0;
    static final int NumberType = 1;
    static final int AnyType = 3;
    static final int TO_OBJECT = 125;
    static final int TO_DOUBLE = 126;
    private static final boolean DEBUG_OPTIMIZER = false;
    private static int debug_blockCount;
    private int itsOptLevel;
    private boolean inDirectCallFunction;
    private boolean parameterUsedInNumberContext;

    Optimizer() {
    }

    void optimize(ScriptOrFnNode scriptOrFn, int optLevel) {
        this.itsOptLevel = optLevel;
        int functionCount = scriptOrFn.getFunctionCount();
        int i = 0;
        while (i != functionCount) {
            OptFunctionNode f = OptFunctionNode.get(scriptOrFn, i);
            this.optimizeFunction(f);
            ++i;
        }
    }

    private void optimizeFunction(OptFunctionNode theFunction) {
        if (theFunction.fnode.requiresActivation()) {
            return;
        }
        this.inDirectCallFunction = theFunction.isTargetOfDirectCall();
        ObjArray statementsArray = new ObjArray();
        Optimizer.buildStatementList_r(theFunction.fnode, statementsArray);
        Object[] theStatementNodes = new Node[statementsArray.size()];
        statementsArray.toArray(theStatementNodes);
        Block[] theBlocks = Block.buildBlocks((Node[])theStatementNodes);
        Object pw = null;
        try {
            block7: {
                try {
                    theFunction.establishVarsIndices();
                    int i = 0;
                    while (i < theStatementNodes.length) {
                        Optimizer.replaceVariableAccess((Node)theStatementNodes[i], theFunction);
                        ++i;
                    }
                    Optimizer.reachingDefDataFlow(theFunction, theBlocks);
                    Optimizer.typeFlow(theFunction, theBlocks);
                    Optimizer.findSinglyTypedVars(theFunction, theBlocks);
                    Optimizer.localCSE(theBlocks, theFunction);
                    if (theFunction.fnode.requiresActivation()) break block7;
                    this.parameterUsedInNumberContext = false;
                    int i2 = 0;
                    while (i2 < theStatementNodes.length) {
                        this.rewriteForNumberVariables((Node)theStatementNodes[i2]);
                        ++i2;
                    }
                    theFunction.setParameterNumberContext(this.parameterUsedInNumberContext);
                }
                catch (IOException x) {
                    Object var9_10 = null;
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            throw throwable;
        }
    }

    private static void findSinglyTypedVars(OptFunctionNode fn, Block[] theBlocks) {
        int i = 0;
        while (i < fn.getVarCount()) {
            int theType;
            OptLocalVariable lVar = fn.getVar(i);
            if (!lVar.isParameter() && (theType = lVar.getTypeUnion()) == 1) {
                lVar.setIsNumber();
            }
            ++i;
        }
    }

    private static void doBlockLocalCSE(Block[] theBlocks, Block b, Hashtable theCSETable, boolean[] beenThere, OptFunctionNode theFunction) {
        if (!beenThere[b.getBlockID()]) {
            beenThere[b.getBlockID()] = true;
            theCSETable = b.localCSE(theCSETable, theFunction);
            Block[] succ = theBlocks[b.getBlockID()].getSuccessorList();
            if (succ != null) {
                int i = 0;
                while (i < succ.length) {
                    int index = succ[i].getBlockID();
                    Block[] pred = theBlocks[index].getPredecessorList();
                    if (pred.length == 1) {
                        Optimizer.doBlockLocalCSE(theBlocks, succ[i], (Hashtable)theCSETable.clone(), beenThere, theFunction);
                    }
                    ++i;
                }
            }
        }
    }

    private static void localCSE(Block[] theBlocks, OptFunctionNode theFunction) {
        boolean[] beenThere = new boolean[theBlocks.length];
        Optimizer.doBlockLocalCSE(theBlocks, theBlocks[0], null, beenThere, theFunction);
        int i = 0;
        while (i < theBlocks.length) {
            if (!beenThere[i]) {
                theBlocks[i].localCSE(null, theFunction);
            }
            ++i;
        }
    }

    private static void typeFlow(OptFunctionNode fn, Block[] theBlocks) {
        boolean[] visit = new boolean[theBlocks.length];
        boolean[] doneOnce = new boolean[theBlocks.length];
        int vIndex = 0;
        boolean needRescan = false;
        visit[vIndex] = true;
        while (true) {
            if (visit[vIndex] || !doneOnce[vIndex]) {
                Block[] succ;
                doneOnce[vIndex] = true;
                visit[vIndex] = false;
                if (theBlocks[vIndex].doTypeFlow() && (succ = theBlocks[vIndex].getSuccessorList()) != null) {
                    int i = 0;
                    while (i < succ.length) {
                        int index = succ[i].getBlockID();
                        visit[index] = true;
                        needRescan |= index < vIndex;
                        ++i;
                    }
                }
            }
            if (vIndex == theBlocks.length - 1) {
                if (!needRescan) break;
                vIndex = 0;
                needRescan = false;
                continue;
            }
            ++vIndex;
        }
    }

    private static void reachingDefDataFlow(OptFunctionNode fn, Block[] theBlocks) {
        int i = 0;
        while (i < theBlocks.length) {
            theBlocks[i].initLiveOnEntrySets(fn);
            ++i;
        }
        boolean[] visit = new boolean[theBlocks.length];
        boolean[] doneOnce = new boolean[theBlocks.length];
        int vIndex = theBlocks.length - 1;
        boolean needRescan = false;
        visit[vIndex] = true;
        while (true) {
            if (visit[vIndex] || !doneOnce[vIndex]) {
                Block[] pred;
                doneOnce[vIndex] = true;
                visit[vIndex] = false;
                if (theBlocks[vIndex].doReachedUseDataFlow() && (pred = theBlocks[vIndex].getPredecessorList()) != null) {
                    int i2 = 0;
                    while (i2 < pred.length) {
                        int index = pred[i2].getBlockID();
                        visit[index] = true;
                        needRescan |= index > vIndex;
                        ++i2;
                    }
                }
            }
            if (vIndex == 0) {
                if (!needRescan) break;
                vIndex = theBlocks.length - 1;
                needRescan = false;
                continue;
            }
            --vIndex;
        }
        int i3 = 0;
        while (i3 < theBlocks.length) {
            theBlocks[i3].markVolatileVariables(fn);
            ++i3;
        }
        theBlocks[0].markAnyTypeVariables(fn);
    }

    private void markDCPNumberContext(Node n) {
        OptLocalVariable theVar;
        if (this.inDirectCallFunction && n.getType() == 59 && (theVar = (OptLocalVariable)n.getProp(13)) != null && theVar.isParameter()) {
            this.parameterUsedInNumberContext = true;
        }
    }

    private boolean convertParameter(Node n) {
        OptLocalVariable theVar;
        if (this.inDirectCallFunction && n.getType() == 59 && (theVar = (OptLocalVariable)n.getProp(13)) != null && theVar.isParameter()) {
            n.removeProp(15);
            return true;
        }
        return false;
    }

    private int rewriteForNumberVariables(Node n) {
        switch (n.getType()) {
            case 51: {
                Node child = n.getFirstChild();
                int type = this.rewriteForNumberVariables(child);
                if (type == 1) {
                    n.putIntProp(15, 0);
                }
                return 0;
            }
            case 40: {
                n.putIntProp(15, 0);
                return 1;
            }
            case 59: {
                OptLocalVariable theVar = (OptLocalVariable)n.getProp(13);
                if (theVar != null) {
                    if (this.inDirectCallFunction && theVar.isParameter()) {
                        n.putIntProp(15, 0);
                        return 1;
                    }
                    if (theVar.isNumber()) {
                        n.putIntProp(15, 0);
                        return 1;
                    }
                }
                return 0;
            }
            case 84: 
            case 85: {
                Node child = n.getFirstChild();
                if (child.getType() == 59) {
                    OptLocalVariable theVar = (OptLocalVariable)child.getProp(13);
                    if (theVar != null && theVar.isNumber()) {
                        n.putIntProp(15, 0);
                        this.markDCPNumberContext(child);
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
            case 60: {
                Node lChild = n.getFirstChild();
                Node rChild = lChild.getNext();
                int rType = this.rewriteForNumberVariables(rChild);
                OptLocalVariable theVar = (OptLocalVariable)n.getProp(13);
                if (this.inDirectCallFunction && theVar.isParameter()) {
                    if (rType == 1) {
                        if (!this.convertParameter(rChild)) {
                            n.putIntProp(15, 0);
                            return 1;
                        }
                        this.markDCPNumberContext(rChild);
                        return 0;
                    }
                    return rType;
                }
                if (theVar != null && theVar.isNumber()) {
                    if (rType != 1) {
                        n.removeChild(rChild);
                        n.addChildToBack(new Node(126, rChild));
                    }
                    n.putIntProp(15, 0);
                    this.markDCPNumberContext(rChild);
                    return 1;
                }
                if (rType == 1 && !this.convertParameter(rChild)) {
                    n.removeChild(rChild);
                    n.addChildToBack(new Node(125, rChild));
                }
                return 0;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                Node lChild = n.getFirstChild();
                Node rChild = lChild.getNext();
                int lType = this.rewriteForNumberVariables(lChild);
                int rType = this.rewriteForNumberVariables(rChild);
                this.markDCPNumberContext(lChild);
                this.markDCPNumberContext(rChild);
                if (this.convertParameter(lChild)) {
                    if (this.convertParameter(rChild)) {
                        return 0;
                    }
                    if (rType == 1) {
                        n.putIntProp(15, 2);
                    }
                } else if (this.convertParameter(rChild)) {
                    if (lType == 1) {
                        n.putIntProp(15, 1);
                    }
                } else if (lType == 1) {
                    if (rType == 1) {
                        n.putIntProp(15, 0);
                    } else {
                        n.putIntProp(15, 1);
                    }
                } else if (rType == 1) {
                    n.putIntProp(15, 2);
                }
                return 0;
            }
            case 22: {
                Node lChild = n.getFirstChild();
                Node rChild = lChild.getNext();
                int lType = this.rewriteForNumberVariables(lChild);
                int rType = this.rewriteForNumberVariables(rChild);
                if (this.convertParameter(lChild)) {
                    if (this.convertParameter(rChild)) {
                        return 0;
                    }
                    if (rType == 1) {
                        n.putIntProp(15, 2);
                    }
                } else if (this.convertParameter(rChild)) {
                    if (lType == 1) {
                        n.putIntProp(15, 1);
                    }
                } else if (lType == 1) {
                    if (rType == 1) {
                        n.putIntProp(15, 0);
                        return 1;
                    }
                    n.putIntProp(15, 1);
                } else if (rType == 1) {
                    n.putIntProp(15, 2);
                }
                return 0;
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                Node lChild = n.getFirstChild();
                Node rChild = lChild.getNext();
                int lType = this.rewriteForNumberVariables(lChild);
                int rType = this.rewriteForNumberVariables(rChild);
                this.markDCPNumberContext(lChild);
                this.markDCPNumberContext(rChild);
                if (lType == 1) {
                    if (rType == 1) {
                        n.putIntProp(15, 0);
                        return 1;
                    }
                    if (!this.convertParameter(rChild)) {
                        n.removeChild(rChild);
                        n.addChildToBack(new Node(126, rChild));
                        n.putIntProp(15, 0);
                    }
                    return 1;
                }
                if (rType == 1) {
                    if (!this.convertParameter(lChild)) {
                        n.removeChild(lChild);
                        n.addChildToFront(new Node(126, lChild));
                        n.putIntProp(15, 0);
                    }
                    return 1;
                }
                if (!this.convertParameter(lChild)) {
                    n.removeChild(lChild);
                    n.addChildToFront(new Node(126, lChild));
                }
                if (!this.convertParameter(rChild)) {
                    n.removeChild(rChild);
                    n.addChildToBack(new Node(126, rChild));
                }
                n.putIntProp(15, 0);
                return 1;
            }
            case 37: 
            case 122: {
                int rValueType;
                int indexType;
                Node arrayBase = n.getFirstChild();
                Node arrayIndex = arrayBase.getNext();
                Node rValue = arrayIndex.getNext();
                int baseType = this.rewriteForNumberVariables(arrayBase);
                if (baseType == 1 && !this.convertParameter(arrayBase)) {
                    n.removeChild(arrayBase);
                    n.addChildToFront(new Node(125, arrayBase));
                }
                if ((indexType = this.rewriteForNumberVariables(arrayIndex)) == 1) {
                    n.putIntProp(15, 1);
                    this.markDCPNumberContext(arrayIndex);
                }
                if ((rValueType = this.rewriteForNumberVariables(rValue)) == 1 && !this.convertParameter(rValue)) {
                    n.removeChild(rValue);
                    n.addChildToBack(new Node(125, rValue));
                }
                return 0;
            }
            case 36: {
                int indexType;
                Node arrayBase = n.getFirstChild();
                Node arrayIndex = arrayBase.getNext();
                int baseType = this.rewriteForNumberVariables(arrayBase);
                if (baseType == 1 && !this.convertParameter(arrayBase)) {
                    n.removeChild(arrayBase);
                    n.addChildToFront(new Node(125, arrayBase));
                }
                if ((indexType = this.rewriteForNumberVariables(arrayIndex)) == 1 && !this.convertParameter(arrayIndex)) {
                    n.putIntProp(15, 2);
                }
                return 0;
            }
            case 38: {
                OptFunctionNode target = (OptFunctionNode)n.getProp(16);
                if (target == null) break;
                Node child = n.getFirstChild();
                this.rewriteForNumberVariables(child);
                child = child.getNext();
                this.rewriteForNumberVariables(child);
                child = child.getNext();
                while (child != null) {
                    int type = this.rewriteForNumberVariables(child);
                    if (type == 1) {
                        this.markDCPNumberContext(child);
                    }
                    child = child.getNext();
                }
                return 0;
            }
        }
        Node child = n.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNext();
            int type = this.rewriteForNumberVariables(child);
            if (type == 1 && !this.convertParameter(child)) {
                n.removeChild(child);
                Node nuChild = new Node(125, child);
                if (nextChild == null) {
                    n.addChildToBack(nuChild);
                } else {
                    n.addChildBefore(nuChild, nextChild);
                }
            }
            child = nextChild;
        }
        return 0;
    }

    private static void replaceVariableAccess(Node n, OptFunctionNode fn) {
        String name;
        OptLocalVariable theVar;
        Node child = n.getFirstChild();
        while (child != null) {
            Optimizer.replaceVariableAccess(child, fn);
            child = child.getNext();
        }
        int type = n.getType();
        if (type == 60) {
            String name2 = n.getFirstChild().getString();
            OptLocalVariable theVar2 = fn.getVar(name2);
            if (theVar2 != null) {
                n.putProp(13, theVar2);
            }
        } else if (type == 59 && (theVar = fn.getVar(name = n.getString())) != null) {
            n.putProp(13, theVar);
        }
    }

    private static void buildStatementList_r(Node node, ObjArray statements) {
        int type = node.getType();
        if (type == 107 || type == 124 || type == 112 || type == 87) {
            Node child = node.getFirstChild();
            while (child != null) {
                Optimizer.buildStatementList_r(child, statements);
                child = child.getNext();
            }
        } else {
            statements.add(node);
        }
    }
}

