/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.impl.mgmt;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.NoSuchDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionManager {
    private static final Log LOG = LogFactory.getLog(DefinitionManager.class);
    private static final String DEFAULT_DEFINITIONS_ATTRIBUTE_NAME = "org.apache.tiles.impl.mgmt.DefinitionManager.DEFINITIONS";
    private DefinitionsFactory factory;
    private String definitionsAttributeName;

    public DefinitionManager() {
        this.definitionsAttributeName = DEFAULT_DEFINITIONS_ATTRIBUTE_NAME;
    }

    public DefinitionManager(String definitionsAttributeName) {
        this.definitionsAttributeName = definitionsAttributeName;
        if (this.definitionsAttributeName == null) {
            this.definitionsAttributeName = DEFAULT_DEFINITIONS_ATTRIBUTE_NAME;
        }
    }

    public DefinitionsFactory getFactory() {
        return this.factory;
    }

    public void setFactory(DefinitionsFactory factory) {
        this.factory = factory;
    }

    public Definition getDefinition(String definition, TilesRequestContext request) throws DefinitionsFactoryException {
        Map<String, Definition> definitions = this.getDefinitions(request);
        if (definitions != null && definitions.containsKey(definition)) {
            return definitions.get(definition);
        }
        return this.getFactory().getDefinition(definition, request);
    }

    public void addDefinition(Definition definition, TilesRequestContext request) throws DefinitionsFactoryException {
        this.validate(definition);
        if (definition.isExtending()) {
            this.resolveInheritance(definition, request);
        }
        this.getOrCreateDefinitions(request).put(definition.getName(), definition);
    }

    private void validate(Definition definition) {
        Map attrs = definition.getAttributes();
        for (Attribute attribute : attrs.values()) {
            if (attribute.getValue() != null) continue;
            throw new IllegalArgumentException("Attribute value not defined");
        }
    }

    protected void resolveInheritance(Definition definition, TilesRequestContext request) throws DefinitionsFactoryException {
        Definition parent;
        if (!definition.isExtending()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolve definition for child name='" + definition.getName() + "' extends='" + definition.getExtends() + "'."));
        }
        if ((parent = this.getDefinition(definition.getExtends(), request)) == null) {
            String msg = "Error while resolving definition inheritance: child '" + definition.getName() + "' can't find its ancestor '" + definition.getExtends() + "'. Please check your description file.";
            LOG.error((Object)msg);
            throw new NoSuchDefinitionException(msg);
        }
        this.resolveInheritance(parent, request);
        this.overload(parent, definition);
    }

    protected void overload(Definition parent, Definition child) {
        for (Map.Entry entry : parent.getAttributes().entrySet()) {
            if (child.hasAttributeValue((String)entry.getKey())) continue;
            child.putAttribute((String)entry.getKey(), new Attribute((Attribute)entry.getValue()));
        }
        if (child.getTemplate() == null) {
            child.setTemplate(parent.getTemplate());
        }
        if (child.getRoles() == null) {
            child.setRoles(parent.getRoles());
        }
        if (child.getPreparer() == null) {
            child.setPreparer(parent.getPreparer());
        }
    }

    protected Map<String, Definition> getDefinitions(TilesRequestContext request) {
        return (Map)request.getRequestScope().get(this.definitionsAttributeName);
    }

    protected Map<String, Definition> getOrCreateDefinitions(TilesRequestContext request) {
        HashMap definitions = (HashMap)request.getRequestScope().get(this.definitionsAttributeName);
        if (definitions == null) {
            definitions = new HashMap();
            request.getRequestScope().put(this.definitionsAttributeName, definitions);
        }
        return definitions;
    }
}

