/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.web.startup;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.factory.TilesContainerFactory;

public class TilesListener
implements ServletContextListener {
    protected static final Log LOG = LogFactory.getLog(TilesListener.class);

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        try {
            TilesContainer container = this.createContainer(servletContext);
            TilesAccess.setContainer((Object)servletContext, (TilesContainer)container);
        }
        catch (TilesException e) {
            throw new IllegalStateException("Unable to instantiate container.", e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        try {
            TilesAccess.setContainer((Object)servletContext, null);
        }
        catch (TilesException e) {
            LOG.warn((Object)"Unable to remove tiles container from service.");
        }
    }

    protected TilesContainer createContainer(ServletContext context) throws TilesException {
        TilesContainerFactory factory = TilesContainerFactory.getFactory(context);
        return factory.createContainer(context);
    }
}

