/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.jgroups.JGroupEventMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JGroupsCacheReplicator
implements CacheReplicator {
    public static final long DEFAULT_ASYNC_INTERVAL = 1000L;
    private static final Log LOG = LogFactory.getLog((Class)JGroupsCacheReplicator.class);
    private long asynchronousReplicationInterval = 1000L;
    private boolean replicatePuts;
    private boolean replicateUpdates;
    private boolean replicateUpdatesViaCopy;
    private boolean replicateRemovals;
    private boolean replicateAsync;
    private ReplicationThread replicationThread;
    private List replicationQueue = new LinkedList();
    private Status status;

    public JGroupsCacheReplicator(boolean replicatePuts, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals, boolean replicateAsync) {
        this.replicatePuts = replicatePuts;
        this.replicateUpdates = replicateUpdates;
        this.replicateUpdatesViaCopy = replicateUpdatesViaCopy;
        this.replicateRemovals = replicateRemovals;
        this.replicateAsync = replicateAsync;
        if (replicateAsync) {
            this.replicationThread = new ReplicationThread();
            this.replicationThread.start();
        }
        this.status = Status.STATUS_ALIVE;
    }

    public boolean isReplicateAsync() {
        return this.replicateAsync;
    }

    public boolean isReplicatePuts() {
        return this.replicatePuts;
    }

    public boolean isReplicateRemovals() {
        return this.replicateRemovals;
    }

    public boolean isReplicateUpdates() {
        return this.replicateUpdates;
    }

    public boolean alive() {
        return true;
    }

    public boolean isReplicateUpdatesViaCopy() {
        return this.replicateUpdatesViaCopy;
    }

    public boolean notAlive() {
        return false;
    }

    public void dispose() {
        this.status = Status.STATUS_SHUTDOWN;
        this.flushReplicationQueue();
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
    }

    protected void sendNotification(Ehcache cache, JGroupEventMessage e) {
        if (this.replicateAsync) {
            this.addMessageToQueue(e);
            return;
        }
        CacheManagerPeerProvider provider = cache.getCacheManager().getCachePeerProvider();
        List l = provider.listRemoteCachePeers(cache);
        ArrayList<JGroupEventMessage> a = new ArrayList<JGroupEventMessage>();
        a.add(e);
        for (int i = 0; i < l.size(); ++i) {
            CachePeer peer = (CachePeer)l.get(i);
            try {
                peer.send(a);
                continue;
            }
            catch (RemoteException e1) {
                // empty catch block
            }
        }
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (this.isReplicatePuts()) {
            this.replicatePutNotification(cache, element);
        }
    }

    private void replicatePutNotification(Ehcache cache, Element element) {
        if (!element.isKeySerializable()) {
            LOG.warn((Object)("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated."));
            return;
        }
        if (!element.isSerializable()) {
            LOG.warn((Object)("Object with key " + element.getObjectKey() + " is not Serializable and cannot be updated via copy"));
            return;
        }
        JGroupEventMessage e = new JGroupEventMessage(0, (Serializable)element.getObjectKey(), element, cache, cache.getName());
        this.sendNotification(cache, e);
    }

    private void replicateRemoveNotification(Ehcache cache, Element element) {
        if (!element.isKeySerializable()) {
            LOG.warn((Object)("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated."));
            return;
        }
        JGroupEventMessage e = new JGroupEventMessage(1, (Serializable)element.getObjectKey(), null, cache, cache.getName());
        this.sendNotification(cache, e);
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (this.isReplicateRemovals()) {
            this.replicateRemoveNotification(cache, element);
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateUpdates) {
            return;
        }
        if (this.isReplicateUpdatesViaCopy()) {
            this.replicatePutNotification(cache, element);
        } else {
            this.replicateRemoveNotification(cache, element);
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (this.isReplicateRemovals()) {
            LOG.trace((Object)"Remove all elements called");
            JGroupEventMessage e = new JGroupEventMessage(3, null, null, cache, cache.getName());
            this.sendNotification(cache, e);
        }
    }

    static List listRemoteCachePeers(Ehcache cache) {
        CacheManagerPeerProvider provider = cache.getCacheManager().getCachePeerProvider();
        return provider.listRemoteCachePeers(cache);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void replicationThreadMain() {
        while (true) {
            if (this.alive() && this.replicationQueue != null && this.replicationQueue.size() == 0) {
                try {
                    Thread.sleep(this.asynchronousReplicationInterval);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Spool Thread interrupted.");
                    return;
                }
            }
            if (this.notAlive()) {
                return;
            }
            try {
                if (this.replicationQueue.size() == 0) continue;
                this.flushReplicationQueue();
                continue;
            }
            catch (Throwable e) {
                LOG.warn((Object)("Exception on flushing of replication queue: " + e.getMessage() + ". Continuing..."), e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageToQueue(JGroupEventMessage msg) {
        List list = this.replicationQueue;
        synchronized (list) {
            this.replicationQueue.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushReplicationQueue() {
        Ehcache cache;
        List resolvedEventMessages;
        List list = this.replicationQueue;
        synchronized (list) {
            if (this.replicationQueue.size() == 0) {
                return;
            }
            resolvedEventMessages = JGroupsCacheReplicator.extractAndResolveEventMessages(this.replicationQueue);
            cache = ((JGroupEventMessage)this.replicationQueue.get(0)).getCache();
            this.replicationQueue.clear();
        }
        List cachePeers = JGroupsCacheReplicator.listRemoteCachePeers(cache);
        for (int j = 0; j < cachePeers.size(); ++j) {
            CachePeer cachePeer = (CachePeer)cachePeers.get(j);
            try {
                cachePeer.send(resolvedEventMessages);
                continue;
            }
            catch (UnmarshalException e) {
                String message = e.getMessage();
                if (message.indexOf("Read time out") != 0) {
                    LOG.warn((Object)("Unable to send message to remote peer due to socket read timeout. Consider increasing the socketTimeoutMillis setting in the cacheManagerPeerListenerFactory. Message was: " + e.getMessage()));
                    continue;
                }
                LOG.debug((Object)("Unable to send message to remote peer.  Message was: " + e.getMessage()));
                continue;
            }
            catch (Throwable t) {
                LOG.warn((Object)("Unable to send message to remote peer.  Message was: " + t.getMessage()), t);
            }
        }
    }

    private static List extractAndResolveEventMessages(List replicationQueueCopy) {
        ArrayList<JGroupEventMessage> list = new ArrayList<JGroupEventMessage>();
        for (int i = 0; i < replicationQueueCopy.size(); ++i) {
            JGroupEventMessage eventMessage = (JGroupEventMessage)replicationQueueCopy.get(i);
            if (eventMessage != null && eventMessage.isValid()) {
                list.add(eventMessage);
                continue;
            }
            LOG.error((Object)"Collected soft ref");
        }
        return list;
    }

    public long getAsynchronousReplicationInterval() {
        return this.asynchronousReplicationInterval;
    }

    public void setAsynchronousReplicationInterval(long asynchronousReplicationInterval) {
        this.asynchronousReplicationInterval = asynchronousReplicationInterval;
    }

    private final class ReplicationThread
    extends Thread {
        public ReplicationThread() {
            super("Replication Thread");
            this.setDaemon(true);
            this.setPriority(5);
        }

        public final void run() {
            JGroupsCacheReplicator.this.replicationThreadMain();
        }
    }
}

