/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.ast.Node;
import org.jruby.ast.executable.YARVCompiledRunner;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.ParserSupport;
import org.jruby.runtime.Block;
import org.jruby.runtime.Constants;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CommandlineParser;

public class Main {
    private CommandlineParser commandline;
    private boolean hasPrintedUsage = false;
    private RubyInstanceConfig config;
    private PrintStream out;
    private PrintStream err;

    public Main(RubyInstanceConfig config) {
        this.config = config;
        this.out = config.getOutput();
        this.err = config.getError();
    }

    public Main(final InputStream in, final PrintStream out, final PrintStream err) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(in);
                this.setOutput(out);
                this.setError(err);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    public static void main(String[] args) {
        Main main = new Main();
        int status = main.run(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    public int run(String[] args) {
        int status;
        this.commandline = new CommandlineParser(this, args);
        if (this.commandline.isShowVersion()) {
            this.showVersion();
        }
        if (!this.commandline.shouldRunInterpreter()) {
            return 0;
        }
        long now = -1L;
        if (this.commandline.isBenchmarking()) {
            now = System.currentTimeMillis();
        }
        try {
            status = this.runInterpreter(this.commandline);
        }
        catch (MainExitException mee) {
            this.err.println(mee.getMessage());
            if (mee.isUsageError()) {
                this.printUsage();
            }
            status = mee.getStatus();
        }
        if (this.commandline.isBenchmarking()) {
            this.out.println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
        }
        return status;
    }

    private void showVersion() {
        this.out.print("ruby ");
        this.out.print(Constants.RUBY_VERSION);
        this.out.print(" (");
        this.out.print(Constants.COMPILE_DATE + " rev " + Constants.REVISION);
        this.out.print(") [");
        this.out.print(System.getProperty("os.arch") + "-jruby" + Constants.VERSION);
        this.out.println("]");
    }

    public void printUsage() {
        if (!this.hasPrintedUsage) {
            this.out.println("Usage: jruby [switches] [--] [rubyfile.rb] [arguments]");
            this.out.println("    -e 'command'    one line of script. Several -e's allowed. Omit [programfile]");
            this.out.println("    -b              benchmark mode, times the script execution");
            this.out.println("    -Jjava option   pass an option on to the JVM (e.g. -J-Xmx512m)");
            this.out.println("    -Idirectory     specify $LOAD_PATH directory (may be used more than once)");
            this.out.println("    --              optional -- before rubyfile.rb for compatibility with ruby");
            this.out.println("    -d              set debugging flags (set $DEBUG to true)");
            this.out.println("    -v              print version number, then turn on verbose mode");
            this.out.println("    -O              run with ObjectSpace disabled (improves performance)");
            this.out.println("    -S cmd          run the specified command in JRuby's bin dir");
            this.out.println("    -C              pre-compile scripts before running (EXPERIMENTAL)");
            this.out.println("    -y              read a YARV-compiled Ruby script and run that (EXPERIMENTAL)");
            this.out.println("    -Y              compile a Ruby script into YARV bytecodes and run this (EXPERIMENTAL)");
            this.out.println("    --command word  Execute ruby-related shell command (i.e., irb, gem)");
            this.hasPrintedUsage = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runInterpreter(CommandlineParser commandline) {
        Reader reader = commandline.getScriptSource();
        String filename = commandline.displayedFileName();
        this.config.updateWithCommandline(commandline);
        Ruby runtime = Ruby.newInstance(this.config);
        runtime.setKCode(commandline.getKCode());
        try {
            int n;
            try {
                this.runInterpreter(runtime, reader, filename);
                n = 0;
                Object var10_8 = null;
            }
            catch (JumpException je) {
                if (je.getJumpType() == JumpException.JumpType.RaiseJump) {
                    RubyException raisedException = ((RaiseException)je).getException();
                    if (raisedException.isKindOf(runtime.getClass("SystemExit"))) {
                        IRubyObject status = raisedException.callMethod(runtime.getCurrentContext(), "status");
                        if (status != null && !status.isNil()) {
                            int n2 = RubyNumeric.fix2int(status);
                            Object var10_9 = null;
                            if (Ruby.isSecurityRestricted()) return n2;
                            if (!runtime.getRuntimeInformation().isEmpty()) {
                                System.err.println("Runtime information dump:");
                                Iterator iter = runtime.getRuntimeInformation().keySet().iterator();
                                while (iter.hasNext()) {
                                    Object key = iter.next();
                                    System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                                }
                            }
                            return n2;
                        }
                        int n3 = 0;
                        Object var10_10 = null;
                        if (Ruby.isSecurityRestricted()) return n3;
                        if (!runtime.getRuntimeInformation().isEmpty()) {
                            System.err.println("Runtime information dump:");
                            Iterator iter = runtime.getRuntimeInformation().keySet().iterator();
                            while (iter.hasNext()) {
                                Object key = iter.next();
                                System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                            }
                        }
                        return n3;
                    }
                    runtime.printError(raisedException);
                    int n4 = 1;
                    Object var10_11 = null;
                    if (Ruby.isSecurityRestricted()) return n4;
                    if (!runtime.getRuntimeInformation().isEmpty()) {
                        System.err.println("Runtime information dump:");
                        Iterator iter = runtime.getRuntimeInformation().keySet().iterator();
                        while (iter.hasNext()) {
                            Object key = iter.next();
                            System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                        }
                    }
                    return n4;
                }
                if (je.getJumpType() != JumpException.JumpType.ThrowJump) {
                    throw je;
                }
                int n5 = 1;
                Object var10_12 = null;
                if (Ruby.isSecurityRestricted()) return n5;
                if (!runtime.getRuntimeInformation().isEmpty()) {
                    System.err.println("Runtime information dump:");
                    Iterator iter = runtime.getRuntimeInformation().keySet().iterator();
                    while (iter.hasNext()) {
                        Object key = iter.next();
                        System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                    }
                }
                return n5;
            }
            catch (MainExitException e) {
                if (!e.isAborted()) {
                    throw e;
                }
                int n6 = e.getStatus();
                Object var10_13 = null;
                if (Ruby.isSecurityRestricted()) return n6;
                if (!runtime.getRuntimeInformation().isEmpty()) {
                    System.err.println("Runtime information dump:");
                    Iterator iter = runtime.getRuntimeInformation().keySet().iterator();
                    while (iter.hasNext()) {
                        Object key = iter.next();
                        System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                    }
                }
                return n6;
            }
            if (Ruby.isSecurityRestricted()) return n;
            if (!runtime.getRuntimeInformation().isEmpty()) {
                System.err.println("Runtime information dump:");
                Iterator iter = runtime.getRuntimeInformation().keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                }
            }
            return n;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (!Ruby.isSecurityRestricted() && !runtime.getRuntimeInformation().isEmpty()) {
                System.err.println("Runtime information dump:");
                Iterator iter = runtime.getRuntimeInformation().keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    System.err.println("[" + key + "]: " + runtime.getRuntimeInformation().get(key));
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInterpreter(Ruby runtime, Reader reader, String filename) {
        try {
            this.initializeRuntime(runtime, filename);
            if (this.commandline.isYARVEnabled()) {
                new YARVCompiledRunner(runtime, reader, filename).run();
            } else {
                Node parsedScript = this.getParsedScript(runtime, reader, filename);
                if (this.commandline.isCompilerEnabled()) {
                    runtime.compileAndRun(parsedScript);
                } else if (this.commandline.isYARVCompileEnabled()) {
                    runtime.ycompileAndRun(parsedScript);
                } else {
                    runtime.compileOrFallbackAndRun(parsedScript);
                }
            }
        }
        finally {
            runtime.tearDown();
        }
    }

    private Node getParsedScript(Ruby runtime, Reader reader, String filename) {
        Node result = runtime.parse(reader, filename, runtime.getCurrentContext().getCurrentScope(), 0);
        if (this.commandline.isAssumePrinting()) {
            result = new ParserSupport().appendPrintToBlock(result);
        }
        if (this.commandline.isAssumeLoop()) {
            result = new ParserSupport().appendWhileLoopToBlock(result, this.commandline.isProcessLineEnds(), this.commandline.isSplit());
        }
        return result;
    }

    private void initializeRuntime(Ruby runtime, String filename) {
        RubyArray argumentArray = runtime.newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(runtime, this.commandline.getScriptArguments()));
        runtime.setVerbose(runtime.newBoolean(this.commandline.isVerbose()));
        runtime.setDebug(runtime.newBoolean(this.commandline.isDebug()));
        this.defineGlobalVERBOSE(runtime);
        this.defineGlobalDEBUG(runtime);
        runtime.getObject().setConstant("$VERBOSE", this.commandline.isVerbose() ? runtime.getTrue() : runtime.getNil());
        runtime.defineGlobalConstant("ARGV", argumentArray);
        this.defineGlobal(runtime, "$-p", this.commandline.isAssumePrinting());
        this.defineGlobal(runtime, "$-n", this.commandline.isAssumeLoop());
        this.defineGlobal(runtime, "$-a", this.commandline.isSplit());
        this.defineGlobal(runtime, "$-l", this.commandline.isProcessLineEnds());
        runtime.getGlobalVariables().defineReadonly("$*", new ValueAccessor(argumentArray));
        runtime.getGlobalVariables().defineReadonly("$$", new ValueAccessor(runtime.newFixnum(runtime.hashCode())));
        ValueAccessor d = new ValueAccessor(runtime.newString(filename));
        runtime.getGlobalVariables().define("$PROGRAM_NAME", d);
        runtime.getGlobalVariables().define("$0", d);
        runtime.getLoadService().init(this.commandline.loadPaths());
        Iterator iter = this.commandline.requiredLibraries().iterator();
        while (iter.hasNext()) {
            String scriptName = (String)iter.next();
            RubyKernel.require(runtime.getTopSelf(), runtime.newString(scriptName), Block.NULL_BLOCK);
        }
    }

    private void defineGlobalVERBOSE(final Ruby runtime) {
        runtime.getGlobalVariables().define("$VERBOSE", new IAccessor(){

            public IRubyObject getValue() {
                return runtime.getVerbose();
            }

            public IRubyObject setValue(IRubyObject newValue) {
                if (newValue.isNil()) {
                    runtime.setVerbose(newValue);
                } else {
                    runtime.setVerbose(runtime.newBoolean(newValue != runtime.getFalse()));
                }
                return newValue;
            }
        });
    }

    private void defineGlobalDEBUG(final Ruby runtime) {
        IAccessor d = new IAccessor(){

            public IRubyObject getValue() {
                return runtime.getDebug();
            }

            public IRubyObject setValue(IRubyObject newValue) {
                if (newValue.isNil()) {
                    runtime.setDebug(newValue);
                } else {
                    runtime.setDebug(runtime.newBoolean(newValue != runtime.getFalse()));
                }
                return newValue;
            }
        };
        runtime.getGlobalVariables().define("$DEBUG", d);
        runtime.getGlobalVariables().define("$-d", d);
    }

    private void defineGlobal(Ruby runtime, String name, boolean value) {
        runtime.getGlobalVariables().defineReadonly(name, new ValueAccessor(value ? runtime.getTrue() : runtime.getNil()));
    }
}

