/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.opt.util.ClassLogger;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;

public class SASLInputStream
extends InputStream {
    private int recvMaxBufSize = 65536;
    private byte[] saslBuffer;
    private byte[] lenBuf = new byte[4];
    private byte[] buf = new byte[0];
    private int bufPos = 0;
    private InputStream in;
    private SaslClient sc;
    private SaslServer ss;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SASLInputStream");

    public SASLInputStream(SaslClient saslClient, InputStream inputStream) throws IOException {
        this.in = inputStream;
        this.sc = saslClient;
        this.ss = null;
        String string = (String)saslClient.getNegotiatedProperty("javax.security.sasl.maxbuffer");
        if (string != null) {
            try {
                this.recvMaxBufSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("javax.security.sasl.maxbuffer property must be numeric string: " + string);
            }
        }
        this.saslBuffer = new byte[this.recvMaxBufSize];
    }

    public SASLInputStream(SaslServer saslServer, InputStream inputStream) throws IOException {
        this.in = inputStream;
        this.ss = saslServer;
        this.sc = null;
        String string = (String)saslServer.getNegotiatedProperty("javax.security.sasl.maxbuffer");
        if (string != null) {
            try {
                this.recvMaxBufSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("javax.security.sasl.maxbuffer property must be numeric string: " + string);
            }
        }
        this.saslBuffer = new byte[this.recvMaxBufSize];
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n > 0) {
            return byArray[0];
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.bufPos >= this.buf.length) {
            n3 = this.fill();
            while (n3 == 0) {
                n3 = this.fill();
            }
            if (n3 == -1) {
                return -1;
            }
        }
        if (n2 > (n3 = this.buf.length - this.bufPos)) {
            System.arraycopy(this.buf, this.bufPos, byArray, n, n3);
            this.bufPos = this.buf.length;
            return n3;
        }
        System.arraycopy(this.buf, this.bufPos, byArray, n, n2);
        this.bufPos += n2;
        return n2;
    }

    private int fill() throws IOException {
        int n = this.readFully(this.lenBuf, 4);
        if (n != 4) {
            return -1;
        }
        int n2 = this.networkByteOrderToInt(this.lenBuf, 0, 4);
        if (n2 > this.recvMaxBufSize) {
            throw new IOException(n2 + "exceeds the negotiated receive buffer size limit:" + this.recvMaxBufSize);
        }
        if (logger.traceOn()) {
            logger.trace("fill", "reading " + n2 + " bytes from network");
        }
        if ((n = this.readFully(this.saslBuffer, n2)) != n2) {
            throw new EOFException("Expecting to read " + n2 + " bytes but got " + n + " bytes before EOF");
        }
        this.buf = this.sc != null ? this.sc.unwrap(this.saslBuffer, 0, n2) : this.ss.unwrap(this.saslBuffer, 0, n2);
        this.bufPos = 0;
        return this.buf.length;
    }

    private int readFully(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        if (logger.traceOn()) {
            logger.trace("readFully", "readFully " + n + " from " + this.in);
        }
        while (n > 0) {
            int n3 = this.in.read(byArray, n2, n);
            if (logger.traceOn()) {
                logger.trace("readFully", "readFully read " + n3);
            }
            if (n3 == -1) {
                return n2 == 0 ? -1 : n2;
            }
            n2 += n3;
            n -= n3;
        }
        return n2;
    }

    public int available() throws IOException {
        return this.buf.length - this.bufPos;
    }

    public void close() throws IOException {
        if (this.sc != null) {
            this.sc.dispose();
        } else {
            this.ss.dispose();
        }
        this.in.close();
    }

    private int networkByteOrderToInt(byte[] byArray, int n, int n2) {
        if (n2 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 <<= 8;
            n3 |= byArray[n + i] & 0xFF;
        }
        return n3;
    }
}

