/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.CompositeListener;
import com.jamonapi.CopyJAMonListener;
import com.jamonapi.JAMonArrayBufferListener;
import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonListener;
import com.jamonapi.NExtremeArrayBufferHolder;
import com.jamonapi.SharedJAMonBufferListener;
import com.jamonapi.utils.BufferHolder;
import com.jamonapi.utils.BufferList;
import com.jamonapi.utils.DateMathComparator;
import com.jamonapi.utils.FIFOBufferHolder;
import com.jamonapi.utils.JAMonArrayComparator;
import com.jamonapi.utils.Misc;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;

public class JAMonListenerFactory {
    private static final boolean NATURAL_ORDER = true;
    private static final boolean REVERSE_ORDER = false;
    private static String[] HEADER = new String[]{"ListenerName", "Listener"};
    private static Map map = Misc.createCaseInsensitiveMap();

    public static void put(JAMonListener jamonListener) {
        map.put(jamonListener.getName(), jamonListener);
    }

    public static Object[][] getData() {
        Iterator iter = map.entrySet().iterator();
        Object[][] data = new Object[map.size()][];
        int i = 0;
        while (iter.hasNext()) {
            data[i] = new Object[2];
            Map.Entry entry = iter.next();
            data[i][0] = entry.getKey();
            data[i][1] = entry.getValue();
            ++i;
        }
        return data;
    }

    public static String[] getHeader() {
        return HEADER;
    }

    public static JAMonListener get(String listenerName) {
        try {
            JAMonListener factoryInstance = (JAMonListener)map.get(listenerName);
            if (factoryInstance instanceof CopyJAMonListener) {
                return ((CopyJAMonListener)((Object)factoryInstance)).copy();
            }
            JAMonListener newInst = (JAMonListener)factoryInstance.getClass().newInstance();
            newInst.setName(factoryInstance.getName());
            return newInst;
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting listener from factory: " + listenerName + ", " + e);
        }
    }

    private static BufferHolder getBufferHolderNLargest7Days() {
        JAMonArrayComparator jac = new JAMonArrayComparator();
        DateMathComparator dmc = new DateMathComparator(6, -7);
        jac.addCompareCol(3, dmc);
        jac.addCompareCol(1, true);
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(jac);
        return bufferHolder;
    }

    private static BufferHolder getBufferHolderNLargest24Hrs() {
        JAMonArrayComparator jac = new JAMonArrayComparator();
        DateMathComparator dmc = new DateMathComparator(11, -24);
        jac.addCompareCol(3, dmc);
        jac.addCompareCol(1, true);
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(jac);
        return bufferHolder;
    }

    private static BufferHolder getBufferHolderNSmallest7Days() {
        JAMonArrayComparator jac = new JAMonArrayComparator();
        DateMathComparator dmc = new DateMathComparator(6, -7);
        jac.addCompareCol(3, dmc);
        jac.addCompareCol(1, false);
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(jac);
        return bufferHolder;
    }

    private static BufferHolder getBufferHolderNSmallest24Hrs() {
        JAMonArrayComparator jac = new JAMonArrayComparator();
        DateMathComparator dmc = new DateMathComparator(11, -24);
        jac.addCompareCol(3, dmc);
        jac.addCompareCol(1, false);
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(jac);
        return bufferHolder;
    }

    private static JAMonBufferListener getFIFO() {
        FIFOBufferHolder bufferHolder = new FIFOBufferHolder();
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new JAMonBufferListener("FIFOBuffer", bufferList);
    }

    private static JAMonBufferListener getNLargest() {
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(true, 1);
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new JAMonBufferListener("NLargestValueBuffer", bufferList);
    }

    private static JAMonBufferListener getNSmallest() {
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(false, 1);
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new JAMonBufferListener("NSmallestValueBuffer", bufferList);
    }

    private static JAMonBufferListener getNLargest7Days() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNLargest7Days());
        return new JAMonBufferListener("NLargestValueBuffer7Days", bufferList);
    }

    private static JAMonBufferListener getNLargest24Hrs() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNLargest24Hrs());
        return new JAMonBufferListener("NLargestValueBuffer24Hrs", bufferList);
    }

    private static JAMonBufferListener getNSmallest7Days() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNSmallest7Days());
        return new JAMonBufferListener("NSmallestValueBuffer7Days", bufferList);
    }

    private static JAMonBufferListener getNSmallest24Hrs() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNSmallest24Hrs());
        return new JAMonBufferListener("NSmallestValueBuffer24Hrs", bufferList);
    }

    private static JAMonBufferListener getSharedFIFO() {
        FIFOBufferHolder bufferHolder = new FIFOBufferHolder();
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new SharedJAMonBufferListener("SharedFIFOBuffer", bufferList);
    }

    private static JAMonBufferListener getSharedNSmallest() {
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(false, 1);
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new SharedJAMonBufferListener("SharedNSmallestValueBuffer", bufferList);
    }

    private static JAMonBufferListener getSharedNLargest() {
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(true, 1);
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new SharedJAMonBufferListener("SharedNLargestValueBuffer", bufferList);
    }

    private static JAMonBufferListener getSharedNLargest7Days() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNLargest7Days());
        return new SharedJAMonBufferListener("SharedNLargestValueBuffer7Days", bufferList);
    }

    private static JAMonBufferListener getSharedNLargest24Hrs() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNLargest24Hrs());
        return new SharedJAMonBufferListener("SharedNLargestValueBuffer24Hrs", bufferList);
    }

    private static JAMonBufferListener getSharedNSmallest7Days() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNSmallest7Days());
        return new SharedJAMonBufferListener("SharedNSmallestValueBuffer7Days", bufferList);
    }

    private static JAMonBufferListener getSharedNSmallest24Hrs() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNSmallest24Hrs());
        return new SharedJAMonBufferListener("SharedNSmallestValueBuffer24Hrs", bufferList);
    }

    private static JAMonBufferListener getExceptionBufferListener() {
        String[] header = new String[]{"Label", "Exception", "LastValue", "Active", "Date"};
        FIFOBufferHolder bufferHolder = new FIFOBufferHolder();
        BufferList bufferList = new BufferList(header, bufferHolder);
        return new JAMonArrayBufferListener("ExceptionBufferListener", bufferList);
    }

    private static JAMonBufferListener getHTTPBufferListener() {
        String[] header = new String[]{"Label", "Exception", "LastValue", "Active", "Date"};
        FIFOBufferHolder bufferHolder = new FIFOBufferHolder();
        BufferList bufferList = new BufferList(header, bufferHolder);
        return new JAMonArrayBufferListener("HTTPBufferListener", bufferList);
    }

    private static void testArray(String label, int dateToAdd, boolean increase) {
        int j;
        int i;
        System.out.print("\n\n****" + label);
        JAMonBufferListener jbl = (JAMonBufferListener)JAMonListenerFactory.get(label);
        BufferList bl = jbl.getBufferList();
        GregorianCalendar cal = new GregorianCalendar();
        if (increase) {
            i = 1;
            j = -50;
            while (i <= 100) {
                cal.setTime(new Date());
                ((Calendar)cal).add(dateToAdd, j);
                bl.addRow(new Object[]{"label" + i, new Integer(i), "Active" + i, cal.getTime()});
                ++i;
                ++j;
            }
        } else {
            i = 100;
            j = 50;
            while (i >= 1) {
                cal.setTime(new Date());
                ((Calendar)cal).add(dateToAdd, j);
                bl.addRow(new Object[]{"label" + i, new Integer(i), "Active" + i, cal.getTime()});
                --i;
                --j;
            }
        }
        int firstVal = -5;
        int secondVal = -10;
        if (dateToAdd == 11) {
            firstVal = -12;
            secondVal = -36;
        }
        cal.setTime(new Date());
        ((Calendar)cal).add(dateToAdd, firstVal);
        bl.addRow(new Object[]{"label", new Integer(1000), "Active", cal.getTime()});
        cal.setTime(new Date());
        ((Calendar)cal).add(dateToAdd, firstVal);
        bl.addRow(new Object[]{"label", new Integer(-1000), "Active", cal.getTime()});
        cal.setTime(new Date());
        ((Calendar)cal).add(dateToAdd, secondVal);
        bl.addRow(new Object[]{"label", new Integer(1000), "Active", cal.getTime()});
        cal.setTime(new Date());
        ((Calendar)cal).add(dateToAdd, secondVal);
        bl.addRow(new Object[]{"label", new Integer(-1000), "Active", cal.getTime()});
        Misc.disp(bl.getData());
    }

    public static void main(String[] args) {
        System.out.println("/n*****Testing JAMonListenerFactory.main()");
        JAMonListenerFactory.put(new CompositeListener("tester"));
        JAMonListenerFactory.put(new JAMonBufferListener("helloListener", new BufferList(new String[]{"hey"}, 200)));
        String[] header = JAMonListenerFactory.getHeader();
        Object[][] data = JAMonListenerFactory.getData();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                System.out.println(header[j] + "=" + data[i][j]);
            }
        }
        System.out.println("\ngetting listener=" + JAMonListenerFactory.get("FIFOBuffer"));
        JAMonBufferListener jbl = (JAMonBufferListener)JAMonListenerFactory.get("helloListener");
        System.out.println("name=" + jbl.getName() + ", buffer=" + jbl.getBufferList().getBufferSize());
        JAMonListenerFactory.testArray("FIFOBuffer", 6, true);
        JAMonListenerFactory.testArray("FIFOBuffer", 6, false);
        JAMonListenerFactory.testArray("NLargestValueBuffer", 6, true);
        JAMonListenerFactory.testArray("NLargestValueBuffer", 6, false);
        JAMonListenerFactory.testArray("NSmallestValueBuffer", 6, true);
        JAMonListenerFactory.testArray("NSmallestValueBuffer", 6, false);
        JAMonListenerFactory.testArray("NLargestValueBuffer7Days", 6, true);
        JAMonListenerFactory.testArray("NLargestValueBuffer7Days", 6, false);
        JAMonListenerFactory.testArray("NSmallestValueBuffer7Days", 6, true);
        JAMonListenerFactory.testArray("NSmallestValueBuffer7Days", 6, false);
        JAMonListenerFactory.testArray("NLargestValueBuffer24Hrs", 11, false);
        JAMonListenerFactory.testArray("NSmallestValueBuffer24Hrs", 11, true);
    }

    static {
        JAMonListenerFactory.put(JAMonListenerFactory.getFIFO());
        JAMonListenerFactory.put(JAMonListenerFactory.getNLargest());
        JAMonListenerFactory.put(JAMonListenerFactory.getNSmallest());
        JAMonListenerFactory.put(JAMonListenerFactory.getNLargest7Days());
        JAMonListenerFactory.put(JAMonListenerFactory.getNLargest24Hrs());
        JAMonListenerFactory.put(JAMonListenerFactory.getNSmallest7Days());
        JAMonListenerFactory.put(JAMonListenerFactory.getNSmallest24Hrs());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedFIFO());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNLargest());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNSmallest());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNLargest7Days());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNLargest24Hrs());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNSmallest7Days());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNSmallest24Hrs());
        JAMonListenerFactory.put(JAMonListenerFactory.getExceptionBufferListener());
        JAMonListenerFactory.put(JAMonListenerFactory.getHTTPBufferListener());
    }
}

