/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class PrintHeadersRecord
extends Record {
    public static final short sid = 42;
    private short field_1_print_headers;

    public PrintHeadersRecord() {
    }

    public PrintHeadersRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 42) {
            throw new RecordFormatException("NOT A PrintHeaders RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_print_headers = in.readShort();
    }

    public void setPrintHeaders(boolean p) {
        this.field_1_print_headers = p ? (short)1 : 0;
    }

    public boolean getPrintHeaders() {
        return this.field_1_print_headers == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PRINTHEADERS]\n");
        buffer.append("    .printheaders   = ").append(this.getPrintHeaders()).append("\n");
        buffer.append("[/PRINTHEADERS]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)42);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_print_headers);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 42;
    }

    public Object clone() {
        PrintHeadersRecord rec = new PrintHeadersRecord();
        rec.field_1_print_headers = this.field_1_print_headers;
        return rec;
    }
}

