/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.ReferenceResolver;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshallerHandler;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentUnmarshaller;
import org.eclipse.persistence.oxm.platform.XMLPlatform;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XMLUnmarshaller {
    public static final int NONVALIDATING = 0;
    public static final int SCHEMA_VALIDATION = 3;
    public static final int DTD_VALIDATION = 2;
    private XMLContext xmlContext;
    private XMLUnmarshallerHandler xmlUnmarshallerHandler;
    private PlatformUnmarshaller platformUnmarshaller;
    private boolean schemasAreInitialized;
    private XMLUnmarshalListener unmarshalListener;
    private XMLAttachmentUnmarshaller attachmentUnmarshaller;
    private Properties unmarshalProperties;
    private Class unmappedContentHandlerClass;

    protected XMLUnmarshaller(XMLContext xmlContext) {
        this.setXMLContext(xmlContext);
        this.initialize();
    }

    private void initialize() {
        DatabaseSession session = this.xmlContext.getSession(0);
        XMLPlatform xmlPlatform = (XMLPlatform)session.getDatasourceLogin().getDatasourcePlatform();
        this.platformUnmarshaller = xmlPlatform.newPlatformUnmarshaller(this);
        this.platformUnmarshaller.setWhitespacePreserving(false);
        this.unmarshalProperties = new Properties();
        this.setValidationMode(0);
    }

    private void initializeSchemas() {
        if (!this.schemasAreInitialized) {
            HashSet<String> schemas = new HashSet<String>();
            int numberOfSessions = this.xmlContext.getSessions().size();
            for (int x = 0; x < numberOfSessions; ++x) {
                for (XMLDescriptor xmlDescriptor : ((DatabaseSession)this.xmlContext.getSessions().get(x)).getDescriptors().values()) {
                    URL schemaURL;
                    XMLSchemaReference xmlSchemaReference = xmlDescriptor.getSchemaReference();
                    if (null == xmlSchemaReference || null == (schemaURL = xmlSchemaReference.getURL())) continue;
                    schemas.add(schemaURL.toString());
                }
            }
            schemas.remove(null);
            this.platformUnmarshaller.setSchemas(schemas.toArray());
            this.schemasAreInitialized = true;
        }
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public void setXMLContext(XMLContext value) {
        this.xmlContext = value;
    }

    public int getValidationMode() {
        return this.platformUnmarshaller.getValidationMode();
    }

    public void resolveReferences(AbstractSession unitOfWork) {
        ReferenceResolver resolver = ReferenceResolver.getInstance(unitOfWork);
        if (resolver != null) {
            resolver.resolveReferences(unitOfWork);
        }
    }

    public void setValidationMode(int validationMode) {
        if (validationMode == 3) {
            this.initializeSchemas();
        }
        this.platformUnmarshaller.setValidationMode(validationMode);
    }

    public EntityResolver getEntityResolver() {
        return this.platformUnmarshaller.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.platformUnmarshaller.setEntityResolver(entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.platformUnmarshaller.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.platformUnmarshaller.setErrorHandler(errorHandler);
    }

    public XMLUnmarshalListener getUnmarshalListener() {
        return this.unmarshalListener;
    }

    public void setUnmarshalListener(XMLUnmarshalListener listener) {
        this.unmarshalListener = listener;
    }

    public Class getUnmappedContentHandlerClass() {
        return this.unmappedContentHandlerClass;
    }

    public void setUnmappedContentHandlerClass(Class aClass) {
        this.unmappedContentHandlerClass = aClass;
    }

    public Object unmarshal(File file) throws XMLMarshalException {
        if (file == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(file);
    }

    public Object unmarshal(File file, Class clazz) throws XMLMarshalException {
        if (null == file || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(file, clazz);
    }

    public Object unmarshal(InputStream inputStream) throws XMLMarshalException {
        if (inputStream == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputStream);
    }

    public Object unmarshal(InputStream inputStream, Class clazz) throws XMLMarshalException {
        if (null == inputStream || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputStream, clazz);
    }

    public Object unmarshal(Reader reader) throws XMLMarshalException {
        if (reader == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(reader);
    }

    public Object unmarshal(Reader reader, Class clazz) throws XMLMarshalException {
        if (null == reader || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(reader, clazz);
    }

    public Object unmarshal(URL url) throws XMLMarshalException {
        if (url == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(url);
    }

    public Object unmarshal(URL url, Class clazz) throws XMLMarshalException {
        if (null == url || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(url, clazz);
    }

    public Object unmarshal(InputSource inputSource) throws XMLMarshalException {
        if (inputSource == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputSource);
    }

    public Object unmarshal(InputSource inputSource, Class clazz) throws XMLMarshalException {
        if (null == inputSource || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputSource, clazz);
    }

    public Object unmarshal(Node node) throws XMLMarshalException {
        if (node == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        if (node.getNodeType() == 9 || node.getNodeType() == 1 || node.getNodeType() == 11) {
            return this.platformUnmarshaller.unmarshal(node);
        }
        throw XMLMarshalException.unmarshalException();
    }

    public Object unmarshal(Node node, Class clazz) throws XMLMarshalException {
        if (null == node || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(node, clazz);
    }

    public Object unmarshal(Source source) throws XMLMarshalException {
        if (source == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(source);
    }

    public Properties getProperties() {
        return this.unmarshalProperties;
    }

    public Object getProperty(Object key) {
        return this.unmarshalProperties.get(key);
    }

    public Object unmarshal(Source source, Class clazz) throws XMLMarshalException {
        if (null == source || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(source, clazz);
    }

    public XMLUnmarshallerHandler getUnmarshallerHandler() {
        if (null == this.xmlUnmarshallerHandler) {
            this.xmlUnmarshallerHandler = new XMLUnmarshallerHandler(this);
        }
        return this.xmlUnmarshallerHandler;
    }

    public XMLAttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.attachmentUnmarshaller;
    }

    public void setAttachmentUnmarshaller(XMLAttachmentUnmarshaller atu) {
        this.attachmentUnmarshaller = atu;
    }

    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.platformUnmarshaller.setResultAlwaysXMLRoot(alwaysReturnRoot);
    }

    public boolean isResultAlwaysXMLRoot() {
        return this.platformUnmarshaller.isResultAlwaysXMLRoot();
    }

    public void setSchema(Schema schema) {
        this.platformUnmarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.platformUnmarshaller.getSchema();
    }
}

