/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;

public class CollectionChangeRecord
extends ChangeRecord
implements oracle.toplink.essentials.changesets.CollectionChangeRecord {
    protected IdentityHashtable addObjectList;
    protected transient Vector orderedAddObjects;
    protected IdentityHashtable orderedAddObjectIndices;
    protected Hashtable orderedRemoveObjects;
    protected transient Vector orderedRemoveObjectIndices;
    protected transient List addOverFlow;
    protected IdentityHashtable removeObjectList;
    protected transient Vector sdkAddObjects;
    protected transient Vector sdkRemoveObjects;
    protected transient Object originalCollection;
    protected transient Object latestCollection;

    public CollectionChangeRecord() {
    }

    public CollectionChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    public void addAdditionChange(IdentityHashMap objectChanges, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        for (Object object : objectChanges.keySet()) {
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            if (change.hasKeys()) {
                this.getAddObjectList().put(change, change);
                continue;
            }
            if (this.getRemoveObjectList().contains(change)) {
                this.getRemoveObjectList().remove(change);
                continue;
            }
            this.getAddObjectList().put(change, change);
        }
    }

    public void addOrderedAdditionChange(Vector objectChanges, IdentityHashtable objectChangesIndices, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        Enumeration e = objectChanges.elements();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            this.getOrderedAddObjects().add(change);
            this.getOrderedAddObjectIndices().put(change, (Integer)objectChangesIndices.get(object));
        }
    }

    public void addOrderedRemoveChange(Vector indicesToRemove, Hashtable objectChanges, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        this.orderedRemoveObjectIndices = indicesToRemove;
        Enumeration e = this.orderedRemoveObjectIndices.elements();
        while (e.hasMoreElements()) {
            Integer index = (Integer)e.nextElement();
            Object object = objectChanges.get(index);
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            this.getOrderedRemoveObjects().put(index, change);
        }
    }

    public void addRemoveChange(IdentityHashMap objectChanges, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        for (Object object : objectChanges.keySet()) {
            ClassDescriptor descriptor = session.getDescriptor(object.getClass());
            ObjectChangeSet change = descriptor.getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            if (change.hasKeys()) {
                this.getRemoveObjectList().put(change, change);
                continue;
            }
            if (this.getAddObjectList().contains(change)) {
                this.getAddObjectList().remove(change);
                continue;
            }
            this.getRemoveObjectList().put(change, change);
        }
    }

    public IdentityHashtable getAddObjectList() {
        if (this.addObjectList == null) {
            this.addObjectList = new IdentityHashtable();
        }
        return this.addObjectList;
    }

    public List getAddOverFlow() {
        if (this.addOverFlow == null) {
            this.addOverFlow = new ArrayList();
        }
        return this.addOverFlow;
    }

    public IdentityHashtable getRemoveObjectList() {
        if (this.removeObjectList == null) {
            this.removeObjectList = new IdentityHashtable();
        }
        return this.removeObjectList;
    }

    public boolean hasChanges() {
        return !this.getAddObjectList().isEmpty() || !this.getRemoveObjectList().isEmpty() || !this.getOrderedAddObjects().isEmpty() || !this.getOrderedRemoveObjects().isEmpty() || this.getOwner().isNew();
    }

    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        Enumeration addEnum = ((CollectionChangeRecord)mergeFromRecord).getAddObjectList().keys();
        while (addEnum.hasMoreElements()) {
            ObjectChangeSet mergingObject = (ObjectChangeSet)addEnum.nextElement();
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            if (this.getRemoveObjectList().containsKey(localChangeSet)) {
                this.getRemoveObjectList().remove(localChangeSet);
                continue;
            }
            this.getAddObjectList().put(localChangeSet, localChangeSet);
        }
        Enumeration removeEnum = ((CollectionChangeRecord)mergeFromRecord).getRemoveObjectList().keys();
        while (removeEnum.hasMoreElements()) {
            ObjectChangeSet mergingObject = (ObjectChangeSet)removeEnum.nextElement();
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            if (this.getAddObjectList().containsKey(localChangeSet)) {
                this.getAddObjectList().remove(localChangeSet);
                continue;
            }
            this.getRemoveObjectList().put(localChangeSet, localChangeSet);
        }
    }

    public void setAddObjectList(IdentityHashtable objectChangesList) {
        this.addObjectList = objectChangesList;
    }

    public void setRemoveObjectList(IdentityHashtable objectChangesList) {
        this.removeObjectList = objectChangesList;
    }

    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        IdentityHashtable addList = new IdentityHashtable(this.getAddObjectList().size());
        IdentityHashtable removeList = new IdentityHashtable(this.getRemoveObjectList().size());
        if (this.getOrderedAddObjects().size() > 0 || this.getOrderedRemoveObjectIndices().size() > 0) {
            Vector<ObjectChangeSet> orderedAddList = new Vector<ObjectChangeSet>(this.getOrderedAddObjects().size());
            IdentityHashtable orderedAddListIndices = new IdentityHashtable(this.getOrderedAddObjectIndices().size());
            for (int i = 0; i < this.getOrderedAddObjects().size(); ++i) {
                ObjectChangeSet changeSet = (ObjectChangeSet)this.getOrderedAddObjects().elementAt(i);
                ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changeSet, mergeFromChangeSet);
                orderedAddList.add(localChangeSet);
                orderedAddListIndices.put(localChangeSet, this.getOrderedAddObjectIndices().get(changeSet));
                if (!this.getAddObjectList().contains(changeSet)) continue;
                addList.put(localChangeSet, localChangeSet);
            }
            this.setOrderedAddObjects(orderedAddList);
            this.setOrderedAddObjectIndices(orderedAddListIndices);
            Hashtable orderedRemoveList = new Hashtable(this.getOrderedRemoveObjects().size());
            Enumeration changes = this.getOrderedRemoveObjects().keys();
            while (changes.hasMoreElements()) {
                Object index = changes.nextElement();
                ObjectChangeSet changeSet = (ObjectChangeSet)this.getOrderedRemoveObjects().get(index);
                ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changeSet, mergeFromChangeSet);
                orderedRemoveList.put(index, localChangeSet);
                if (!this.getRemoveObjectList().contains(changeSet)) continue;
                removeList.put(localChangeSet, localChangeSet);
            }
            this.setOrderedRemoveObjects(orderedRemoveList);
        } else {
            ObjectChangeSet localChangeSet;
            Enumeration changes = this.getAddObjectList().elements();
            while (changes.hasMoreElements()) {
                localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)changes.nextElement(), mergeFromChangeSet);
                addList.put(localChangeSet, localChangeSet);
            }
            changes = this.getRemoveObjectList().elements();
            while (changes.hasMoreElements()) {
                localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)changes.nextElement(), mergeFromChangeSet);
                removeList.put(localChangeSet, localChangeSet);
            }
        }
        this.setAddObjectList(addList);
        this.setRemoveObjectList(removeList);
    }

    public Vector getAddObjectsForSDK() {
        if (this.sdkAddObjects == null) {
            this.sdkAddObjects = new Vector();
            Enumeration enumtr = this.getAddObjectList().keys();
            while (enumtr.hasMoreElements()) {
                this.sdkAddObjects.add(enumtr.nextElement());
            }
        }
        return this.sdkAddObjects;
    }

    public void setAddObjectsForSDK(Vector addObjects) {
        this.sdkAddObjects = addObjects;
        IdentityHashtable newList = new IdentityHashtable();
        for (int i = 0; i < this.sdkAddObjects.size(); ++i) {
            Object change = this.sdkAddObjects.elementAt(i);
            newList.put(change, change);
        }
        this.setAddObjectList(newList);
    }

    public Vector getRemoveObjectsForSDK() {
        if (this.sdkRemoveObjects == null) {
            this.sdkRemoveObjects = new Vector();
            Enumeration enumtr = this.getRemoveObjectList().keys();
            while (enumtr.hasMoreElements()) {
                this.sdkRemoveObjects.add(enumtr.nextElement());
            }
        }
        return this.sdkRemoveObjects;
    }

    public void setRemoveObjectsForSDK(Vector removeObjects) {
        this.sdkRemoveObjects = removeObjects;
        IdentityHashtable newList = new IdentityHashtable();
        for (int i = 0; i < this.sdkRemoveObjects.size(); ++i) {
            Object change = this.sdkRemoveObjects.elementAt(i);
            newList.put(change, change);
        }
        this.setRemoveObjectList(newList);
    }

    public Object getLatestCollection() {
        return this.latestCollection;
    }

    public Vector getOrderedAddObjects() {
        if (this.orderedAddObjects == null) {
            this.orderedAddObjects = new Vector();
        }
        return this.orderedAddObjects;
    }

    public Integer getOrderedAddObjectIndex(ObjectChangeSet changes) {
        return (Integer)this.getOrderedAddObjectIndices().get(changes);
    }

    public IdentityHashtable getOrderedAddObjectIndices() {
        if (this.orderedAddObjectIndices == null) {
            this.orderedAddObjectIndices = new IdentityHashtable();
        }
        return this.orderedAddObjectIndices;
    }

    public Vector getOrderedRemoveObjectIndices() {
        if (this.orderedRemoveObjectIndices == null) {
            this.orderedRemoveObjectIndices = new Vector();
        }
        return this.orderedRemoveObjectIndices;
    }

    public Object getOrderedRemoveObject(Integer index) {
        return this.getOrderedRemoveObjects().get(index);
    }

    public Hashtable getOrderedRemoveObjects() {
        if (this.orderedRemoveObjects == null) {
            this.orderedRemoveObjects = new Hashtable();
        }
        return this.orderedRemoveObjects;
    }

    public void setLatestCollection(Object latestCollection) {
        this.latestCollection = latestCollection;
    }

    public void setOrderedAddObjectIndices(IdentityHashtable orderedAddObjectIndices) {
        this.orderedAddObjectIndices = orderedAddObjectIndices;
    }

    public void setOrderedAddObjects(Vector orderedAddObjects) {
        this.orderedAddObjects = orderedAddObjects;
    }

    public void setOrderedRemoveObjects(Hashtable orderedRemoveObjects) {
        this.orderedRemoveObjects = orderedRemoveObjects;
    }

    public Object getOriginalCollection() {
        return this.originalCollection;
    }

    public void setOriginalCollection(Object originalCollection) {
        this.originalCollection = originalCollection;
    }
}

